//Popi Gram for 2 Microphones

#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../Common/Array/Array.h" 
#include "../Common/IO/IO.h" 
#include "../Common/SignProc/SignProc.h" 
#include "./PopiSift.h" 


/*Microphone Array All Frame*/
void MicArrAllFrames(float *AM, float *ys, int nch, int ns, int nf, int FS, int FL)
{ 
  int f,c,s;  
  for(f=0; f<nf; f++)   
  {    
    for(s=0; s<FL; s++)  
    {  
      for(c=0; c<nch; c++) 
      {  
	AM[c+s*nch+f*nch*FL]=ys[c+(f*FS+s)*nch];     //AM[nch*P.FL*P.nf], ys[nch*ns]  
      }
    }
  }    
}


/*Basic Comb Filter*/
void BCombF(int *bc, int MiPitSa,int MaPitSa, int Np)
{
  int p, n;    
  for(p=0; p<=MaPitSa; p++)  
  {
    for(n=0; n<Np; n++)  bc[n+p*Np]=n*p;
  }   
}

/*All Frames SubM*/
void AllFSubM(float *SM, float *AM, int nch, int FL, int nf, int *bc, int Np)
{
  int f,s,c,s1,f1, s1b, f1b;  
  for(f=0; f<nf; f++)   
  { 
    f1=f*nch*Np;    f1b=f*nch*FL;
    for(s=0; s<Np; s++)  
    {  
      s1=s*nch; s1b=bc[s]*nch;
      for(c=0; c<nch; c++) 
      {  
	SM[c+s1+f1]=AM[c+s1b+f1b];  //AM[c+s*nch+f*nch*FL];	
      }
    }
  } 
}
/*Cross Product*/
void CrossProd(float *CP, float *SM, int nf, int l, int *ci1, int *ci2, int cil)
{
  int f, i, f2;
  float a;
  for(f=0; f<nf; f++) 
  {
    a=0; f2=f*l;
    for(i=0; i<cil; i++)
    {
      a=a+SM[ci1[i]+f2]*SM[ci2[i]+f2];
    }
    CP[f]=a;    
  }    

}



/*Microphone Array Sift R0*/
void SiftR0Sign(float *S, float *AM, int nch, int FL, int nf, int p, int *bc, int *ci1, int *ci2, int cil, int Np, int l)
{
  //AM[nch*P.FL*P.nf] 
  int k, *bc2;
  float *SM, *CP;   
  CP=AllocM(nf, 1); SM=AllocM(nf,(Np*nch));
  bc2=AllocIntM(1, Np); 
  ZerosM(S,nf,1);  
  for(k=0; k<p; k++)
  {
    SumIntMS(bc2, bc, 1, Np, k);     
    AllFSubM(SM, AM, nch, FL, nf, bc2, Np);      
    CrossProd(CP, SM, nf, l, ci1, ci2, cil);     
    SumM1M2(S, S, CP, nf, 1);       
  }  
}



/*Pit (of Popi) Signal*/
void PiSign(char *fn, float *ys, int nch, int ns, Param P)
{
  
  int p, l=nch*P.Np, cil=l*(l-1)/2, *ci1, *ci2, *BC;
  float *AM,  *S; 
  FILE *fp = NULL; 
  
  //Allocate Dynamic Memory (int, float, FILE)
  AM=AllocM(nch*P.FL, P.nf); S=AllocM(P.nf, 1);   
  ci1=AllocIntM(1, cil);  ci2=AllocIntM(1, cil); BC=AllocIntM(P.Np,(1+P.MaPitSa));    
  fp=fopen(fn,"wb");    
  //Init
  nchoose2(ci1, ci2, l);    
  BCombF(BC, P.MiPitSa, P.MaPitSa, P.Np);   
  MicArrAllFrames(AM, ys, nch, ns, P.nf, P.FS, P.FL);  
  
  //
  for(p=P.MiPitSa; p<=P.MaPitSa; p++)
  {		
      SiftR0Sign(S, AM, nch, P.FL, P.nf, p, &BC[p*P.Np], ci1, ci2, cil, P.Np, l); 
      fwrite(S, sizeof(float), P.nf, fp);      
  } 
  fclose(fp);
  printf("Writted %s\n",fn);
  
}


int main(int argc, char *argv[]) 
{

  char fni[MaxFNL], fno[MaxFNL];
  int nr, nc;
  float *ys;	
  Param P;
  
  //Read Inputs 
  ReStrF(&P,argv[4]);
  
  
  CatFN(fni, argv[1], argv[3], ".ys");
  CatFN(fno, argv[2], argv[3], ".PiSign");     
  ys = ReHtkF(&nr,&nc,fni);
  
  //
  PiSign(fno, ys, nr, nc, P);
  
 
	

  return 0;

}	











