//Popi Gram for 2 Microphones

#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "../Common/Array/Array.h" 
#include "../Common/IO/IO.h" 
#include "../Common/SignProc/SignProc.h" 
#include "./PopiSift.h" 




/* Main function 
../bin/PopiSift ../bin/DemoIO/I ../bin/DemoIO/O alzn3370_LIO2 ../bin/DemoIO/I/FEConfig.txt
*/

int main(int argc, char *argv[]) 
{

  char fn0[MaxFNL], fn1[MaxFNL], fno[MaxFNL];
  int nr, nc;
  float *X0, *X1, *R;	
  Param P;
  
  //Read Inputs 
  ReStrF(&P,argv[4]);
  printf("Doing PopiGram\n");
  CatFN(fn0, argv[1], argv[3], "_0.M");
  CatFN(fn1, argv[1], argv[3], "_1.M");
  CatFN(fno, argv[2], argv[3], ".PopiG");     
  X0 = ReHtkF(&nr,&nc,fn0);
  X1 = ReHtkF(&nr,&nc,fn1);
  
  //Cross Correlation
  R = AllocM(2*nr-1, nc);		
  XcorrM(R, X0, X1, nr, nc, 'u');
  free(X0); free(X1);
  
  //PopiG and write it
  PopiG(fno, R, 2*nr-1, nc, P);      
	

  return 0;

}			












