#include <stdio.h> 
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "../Common/Array/Array.h" 
#include "../Common/IO/IO.h" 
#include "../Common/SignProc/SignProc.h" 


/*Delay-Pitch Popi Signal. 
hbn (half bin n)*/	  
float* DelPitFPopiS(float *C, int nr, int nc, int d, int p, int hbn, Param P)
{
  
  int i, hnr, b[2*hbn+1];
  float *PopiS, *S;
  
  hnr=(nr-1)/2;  
  
  PopiS=AllocM(1, nc);     
  //
  for(i=0; i<=hbn; i++) {b[hbn+i]=i; b[hbn-i]=-i;} 
  for(i=0; i<=2*hbn+1; i++) {b[i]=p*b[i]+d+(hnr);}         
  //     
  S=ASubM(C, nr, nc, b, 2*hbn+1, b, -1);     
  PopiS=ASumM(S, 2*hbn+1, nc, 1);
    
  return PopiS;  
}




/*PopiGram*/	  
void PopiG(char *fn, float *C, int nr, int nc, Param P)
{
  int d,p;
  float *PopiS=NULL;
  FILE *fp = fopen (fn, "wb" );

  
  for(p=P.MiPitSa; p<=P.MaPitSa; p++)  
  {      
    
    for(d=P.MiADelSa; d<=P.MaADelSa; d++) 
    { 
      PopiS=DelPitFPopiS(C, nr, nc, d, p, 2, P);        
      fwrite(PopiS, sizeof(float), nc, fp);        
    }      
  }  
  fclose(fp);
  
  printf("Writted %s\n",fn);      
  
}
