#include <stdio.h> //fopen, printf 
#include <stdlib.h> //rand, abs, system 
#include <sys/time.h> //timeval
#include <math.h> //sqrt, fabs, ceil
#include <complex.h>    //Complex Numbers 


#include "./SignProc.h" 
#include "../IO/IO.h" 

/*Xcorr of two Vectors. r is always 2*lx-1*/
int XcorrV(float *r, float *x1, float *x2, int lx, char kind)
{
	int i, s;
	float w[2*lx-1+2], aux;
	
	
	
	//Pos part
	for(s=0; s<lx; s++)
	{
		aux=0;
		for(i=0; i<lx-s; i++)
			aux=aux+(x1[i+s]*x2[i]);
		r[s+lx-1]=aux/(float)(lx-s);
	}

	//Neg part
	for(s=0; s<lx; s++)
	{
		aux=0;
		for(i=0; i<lx-s; i++)
			aux=aux+(x1[i]*x2[i+s]);
		r[lx-s-1]=aux/(float)(lx-s);
	}

	//If Biased
	if(kind=='b')
	{
		Triang(w, 2*lx-1+2); //+2 because r[0] with w[1] is not 0 (Barlett).
		for(i=0; i<2*lx-1; i++)
			r[i]=r[i]*w[i+1];		
	}		
	
	return 2*lx-1;	
}


/*Xcorr of a Matrix. Corr of each columns pairs*/
void XcorrM(float *R, float *X1, float *X2, int nr, int nc, char kind)
{
	int j, a=2*nr-1;
	
	for(j=0; j<nc; j++) //for each column
	{  	  
	  XcorrV(&R[0+j*a], &X1[0+j*nr], &X2[0+j*nr], nr, kind);	  
	}  
	  
}





