//Input Output FILE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
 
 
#include "./IO.h" 
#include "../Array/Array.h" 
 
typedef struct HtkHead{
                          unsigned int nSamples;
                          unsigned int sampPeriod;
                          unsigned short int sampSize;
                          unsigned short int sampKind;
                          }HtkHead;



		  
			  
			  
			  
//////////////////////////////////////////////// SubFun /////////////////////////////////////////////
			  
/*Read Htk Header*/
void ReHtkHeader (FILE *fp, int *nf, char *kind, int *lv)
{
    HtkHead header;
    
    fseek (fp, 0L, SEEK_SET);
    fread (&header.nSamples, sizeof (long), 1, fp);
    fread (&header.sampPeriod, sizeof (long), 1, fp);
    fread (&header.sampSize, sizeof (short), 1, fp);
    fread (&header.sampKind, sizeof (short), 1, fp);
	
    *nf= header.nSamples;
    *lv = header.sampSize/4;    
    *kind=header.sampKind;
    
    //printf("%d %d %d ", *nf, *lv, *kind);
    //getchar();
    
	
}



//////////////////////////////////////////////// Fun /////////////////////////////////////////////


/*ConCatenate a File Name*/
void CatFN(char *fn, char *dir, char *bn, char *ext)
{
  strcpy (fn,dir); strcat (fn,"/"); strcat (fn,bn); strcat (fn,ext);  
}


/*Read Structurure File*/
void ReStrF(Param *P, char *FName)
{
  
  char l[128], fn[128], *sp;  
  int ll;
  FILE *fp = fopen (FName, "r" );  
  
  
    
     
  while ( fgets (l, sizeof(l), fp) != NULL ) 
  {
    sp=strstr(l, "=");  
    ll=sp-l-1;    
    strncpy(fn, l, ll); fn[ll]='\0';   
    
    if(!strcmp(fn, "FSamp"))  {
      P->FSamp=atof(sp+1); } 
    else if(!strcmp(fn, "NCH"))     {
      P->NCH=atoi(sp+1);    } 
    else if(!strcmp(fn, "FLSec"))   {
      P->FLSec=atof(sp+1);  } 
    else if(!strcmp(fn, "FSSec"))    {
      P->FSSec=atof(sp+1);  } 
    
    else if(!strcmp(fn, "FL"))    {
      P->FL=atoi(sp+1);  } 
    else if(!strcmp(fn, "FS"))    {
      P->FS=atoi(sp+1);  }   
      
    else if(!strcmp(fn, "MaPitS"))    {
      P->MaPitS=atoi(sp+1);  }  
    else if(!strcmp(fn, "MiPitS"))    {
      P->MiPitS=atoi(sp+1);  }     
    else if(!strcmp(fn, "MaADelS"))    {
      P->MaADelS=atoi(sp+1);  }  
    else if(!strcmp(fn, "MiADelS"))    {
      P->MiADelS=atoi(sp+1);  }       
    else if(!strcmp(fn, "Np"))    {
      P->Np=atoi(sp+1);  }
    else if(!strcmp(fn, "nf"))    {
      P->nf=atoi(sp+1);  }    
      
    
  }  
  
  fclose(fp);  
  //P->FL=roundf(P->FSamp*P->FLSec);  
  //P->FS=roundf(P->FSamp*P->FSSec);
  
  
  
  
}





/*Read Htk File
Call: int nr, nc; float *M; M=ReHtkF(&nr,&nc,argv[1]);*/
float* ReHtkF(int *nr, int *nc, char *fn)
{
	FILE *fp=NULL; 
	char khead;
	int j;
	float *M;
	
	
	fp=fopen(fn, "rb");	
	if(fp==NULL) 
	{printf("ERROR in ReHtkF: can not open %s\n",fn); return (float*) -1;}
	
	
	
	ReHtkHeader(fp, nc, &khead, nr); //nr and nc		
	//M = (float*) malloc((*nr)*(*nc) * sizeof(float));
	M = AllocM(*nr,*nc);
	
	for(j=0; j<*nc; j++)
	  fread(&M[0+j*(*nr)], sizeof(float), *nr, fp); //M[i+j*nr]=M[i][j]	  
	fclose(fp);	
	return M;	
}





