#include <stdio.h> //fopen, printf 
#include <stdlib.h> //rand, abs, system 
#include <sys/time.h> //timeval
#include <math.h> //sqrt, fabs, ceil

#include "../IO/IO.h" 


/*Allocate Matrix */
float* AllocM(int nr, int nc)
{
  float *M;
  M = (float*) malloc((nr*nc) * sizeof(float));
  return M;
}

/*Allocate Integer Matrix */
int* AllocIntM(int nr, int nc)
{
  int *M;  
  //printf("WANING in AllocIntM: can produce errors, use directly m[nr][nc]\n");
  M = (int*) malloc((nr*nc) * sizeof(int));    
  return M;
}

/*Matlab: Different combinations of 2 elements of (0,.., n-1)
Element Num: n*(n-1)/2*/
void nchoose2(int *ci1, int *ci2, int n)
{
  int i,j,k=0;
  
  for(i=0; i<n; i++)  
  { 
    for(j=i+1; j<n; j++)  
    {
      ci1[k]=i; ci2[k]=j;           
      k++;
    }   
  }
  
}



/*Allocate SubMatrix
-1 in lri or lci means throughout the corresponding dimension*/
float* ASubM(float *M, int nr, int nc, int *ri, int lri, int *ci, int lci)
{ 
  int i, j;
  float *SM;    
  if(lci==-1 && lri>-1) //For all columns
      {lci=nc; SM = AllocM(lri,lci);	
      for(j=0; j<lci; j++){ for(i=0; i<lri; i++) SM[i+j*lri]=M[ri[i]+j*nr];}}      
  else if (lci>-1 && lri==-1) //For all rows
      {lri=nr; SM = AllocM(lri,lci);	
      for(j=0; j<lci; j++){ for(i=0; i<lri; i++) SM[i+j*lri]=M[i+ci[j]*nr];}}  
  else   //For ramdon elements
      {SM = AllocM(lri,lci);
      for(j=0; j<lci; j++){ for(i=0; i<lri; i++) SM[i+j*lri]=M[ri[i]+ci[j]*nr];}}   
  return SM;
}

/*Fill with Zeros a Matrix*/
void ZerosM(float *M, int nr, int nc)
{
  int i,j;
  for(j=0; j<nc; j++)
  {
    for(i=0; i<nr; i++)
	M[i+j*nr]=0;
  }   
}

/*SubMatrix
-1 in lri or lci means throughout the corresponding dimension*/
void SubM(float *SM, float *M, int nr, int nc, int *ri, int lri, int *ci, int lci)
{ 
  int i, j;    
  if(lci==-1 && lri>-1) //For all columns
      {lci=nc; 	
      for(j=0; j<lci; j++){ for(i=0; i<lri; i++) SM[i+j*lri]=M[ri[i]+j*nr];}}      
  else if (lci>-1 && lri==-1) //For all rows
      {lri=nr; 	
      for(j=0; j<lci; j++){ for(i=0; i<lri; i++) SM[i+j*lri]=M[i+ci[j]*nr];}}  
  else   //For ramdon elements
      {for(j=0; j<lci; j++){ for(i=0; i<lri; i++) SM[i+j*lri]=M[ri[i]+ci[j]*nr];}}   
}




/*Allocate Sum Matrix
dim 1,2 and -1 means sum throughout dimension row, colum and all*/
float* ASumM(float *M, int nr, int nc, int dim)
{
  int i, j;
  float *s;  
  
  if (dim==1) 
    {s=AllocM(1,nc);  
    for(j=0; j<nc; j++){ s[j]=0; for(i=0; i<nr; i++) s[j]=s[j]+M[i+j*nr];}}
    
  else if (dim==2)
    {s=AllocM(nr,1);  
    for(i=0; i<nr; i++) {s[i]=0; for(j=0; j<nc; j++)  s[i]=s[i]+M[i+j*nr];}}
    
  else 
    {s=AllocM(1,1);  
    s[0]=0; for(j=0; j<nc; j++){ for(i=0; i<nr; i++) s[0]=s[0]+M[i+j*nr];}}  
    
  return s;
  
}

/*Allocate Sum Int Matrix
dim 1,2 and -1 means sum throughout dimension row, colum and all*/
float* ASumIntM(int *M, int nr, int nc, int dim)
{
  int i, j;
  float *s;  
  
  if (dim==1) 
    {s=AllocM(1,nc);  
    for(j=0; j<nc; j++){ s[j]=0; for(i=0; i<nr; i++) s[j]=s[j]+(float) M[i+j*nr];}}
    
  else if (dim==2)
    {s=AllocM(nr,1);  
    for(i=0; i<nr; i++) {s[i]=0; for(j=0; j<nc; j++)  s[i]=s[i]+(float) M[i+j*nr];}}
    
  else 
    {s=AllocM(1,1);  
    s[0]=0; for(j=0; j<nc; j++){ for(i=0; i<nr; i++) s[0]=s[0]+(float) M[i+j*nr];}}  
    
  return s;
  
}



/*Sum Integer Matrix and Scalar*/
void SumIntMS(int *RM, int *M, int nr, int nc, int s)
{
  int i,j, j2;  
  for(j=0; j<nc; j++) 
  {
    j2=j*nr;
    for(i=0; i<nr; i++)  
      RM[i+j2]=M[i+j2]+s;
  }  
}  

/*Sum M1 and M2*/
void SumM1M2(float *RM, float *M1, float *M2, int nr, int nc)
{
  int i,j, j2;
  for(j=0; j<nc; j++)
  { 
    j2=j*nr;
    for(i=0; i<nr; i++) 
      RM[i+j2]=M1[i+j2]+M2[i+j2];
  }    
}




