function [M,Du,Vo,PiF,StF]=Text2PhAcFe(Com,PhDurSec)
%Text To Phone Acoustic Features
%Magnitude of the Channels, Voiced, Pitch Factor, Stress Factor

[Ph,StF,PiF]=Text2PhPro(Com);
[M,Du,Vo]=Ph2AcFe(Ph,PhDurSec);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [M,Du,Vo]=Ph2AcFe(Ph,PhDurSec)
%Phone To Acoustic Features
l=length(Ph);
for i=1:l    
    [M{i},Du{i},Vo{i}]=AcFe1Ph(Ph{i},PhDurSec);          
end
Vo=Merg1Cell(Vo);
Du=Merg1Cell(Du);
M=Merg1Cell(M);



function [M,Du,Vo]=AcFe1Ph(Ph,PhDurSec)
%Phone To Acoustic Features
%low    high freq
AM=[0 1 0 0 0 1 0 
    0 0 1 0 1 1 0
    0 0 0 1 1 0 0 
    0 0 1 0 0 0 0
    0 1 0 0 0 0 1];   
APh={'s' 'i' 'e' 'a' 'o' 'u' 'f'};

switch Ph
    case '<SIL>'
        Ph='s';
        Du=PhDurSec*4;
        Vo=0;    
    case '<SP>'
        Ph='s';
        Du=PhDurSec/2;
        Vo=0;         
    case {'i' 'e' 'a' 'o' 'u'}
        Ph=Ph;
        Du=PhDurSec;
        Vo=1;        
    case {'s' 'f' 'z' 'g'}     
        Ph='f';
        Du=PhDurSec;
        Vo=0;        
    otherwise
        Ph='f';  
        Du=PhDurSec/4;
        Vo=0;
end
i=strcmp(Ph,APh);
M=AM(:,i);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Ph,StF,PiF]=Text2PhPro(Text)
%Text To Ph and Prosody
%Ph: Phoneme
%StF: Stress Factor
%PitF: Pitch Factor

W=EmbedSPSplW(Text);
l=length(W);
for i=1:l
    [Ph{i}, StF{i}, PiF{i}]=W2Ph(W{i});        
end
Ph=Merg1Cell(Ph);
StF=Merg1Cell(StF);
PiF=Merg1Cell(PiF);


function B=Merg1Cell(A)
%
l=length(A);
B=[];
for i=1:l
    B=[B A{i}];      
end   


function [Ph,St,Pi]=W2Ph(W)
%
PiF=3/4;%Pitch Factor [0 1]

switch W
    case {'<SIL>','<SP>'}
        Ph{1}=W;
        St(1)=1;
        Pi(1)=1;
    otherwise
        l=length(W); for i=1:l; Ph{i}=lower(W(i)); end
        St=ones(1,l); St(randi(l))=2;    
        Pi=ones(1,l); Pi(randi(l))=PiF; Pi(randi(l))=1/PiF;
        
end


function WF=EmbedSPSplW(Text)
%Embed Short Pause and Split in Words
W=strsplit(Text);
l=length(W);
WF={}; j=1;
for i=1:l
    WF{j}=W{i}; j=j+1;
    WF{j}='<SP>'; j=j+1; 
end
