function St=GenDirSpeech(do,NUtt,FSamp,CAP)
%Generate Directory of Speech signals (.wav)
%do: Dir Output
%NUtt: Number of Utterances
%FSamp: Sample Frequency

%Default
switch nargin
    case 0
        %Inputs/Outputs
        do='/tmp/SpDir'; 
        NUtt=10;
        FSamp=16000;
end
[x,x,x]=mkdir(do);

%Parameters Intervals
PiHz=[80 250]; %Humman pitch in Herz
PhDurSec=[1/7 1/3]; %Phone duration in Herz



%Draw Text Utterances from a Grammar
Utt=DrawTextUttGr(NUtt);

%
for i=1:NUtt
    
    %Chose random parameters from the intervals
    MePi=rand(1)*(PiHz(2)-PiHz(1))+PiHz(1); %Mean Pitch
    PhDur=rand(1)*(PhDurSec(2)-PhDurSec(1))+PhDurSec(1); %Phone Duration
    %Pos=APos(randi(length(APos))); %Position    
    PosAngDe=randi(360); %Posintion in Angle Degrees
    
    
    
    %Synthesis 
    [M,Du,Vo,PiF,StF]=Text2PhAcFe(Utt{i},PhDur);
    s=PhAcFe2GammSignal(M,Du,Vo,PiF,StF,FSamp,MePi);
    %s2=Mono2SimHouse(s,FSamp,Pos,FSamp,APos);
    s2=Mono2SimCircMicArray(s,FSamp,PosAngDe,FSamp,CAP);
    
    
    %Write signal
    fn=[do '/Utt' num2str(i) '.wav'];
    audiowrite(fn,s2,FSamp);
    fprintf('Written: %s with transcription %s\n',fn,Utt{i});
    
    %
    St(i).y=s2;
    St(i).Trans=Utt{i};
    St(i).PosAngDe=PosAngDe;
    
%     %Plot    
%     subplot(211), plot(s)
%     subplot(212), plot(s2)
%     Utt{i}
%     soundsc(s,FSamp);    
%     pause
    
end























