function [s,CG,GamCFHz]=GammSignal(DurSec,PitHz,M,FSampHz)
%Gammatone Signal
%PitHz:     -1 (white excitation). 50 (cte pitch). [100 200 150 250] smooth
%           pitch interpolation along the DurSec
%M:         Channel magnitude distributed to the NCH [1 0 0], [0 0 1 0 0].


%
NCH     = 26; %Number of channels
LCFHz   = 50; % Low Center Freq (50 Hz)
HCFHz   = round(FSampHz/2-(FSampHz/(NCH))); %High Center Freq  (3750 or 7500  Hz)
ExSamp  = FSampHz; %Extra Samples
NSamp   = round(DurSec*FSampHz);  
GamCFHz = MakeErbCFs(LCFHz,HCFHz,NCH);  %Gammatone Center Freq in Hz


%Flat signal 
e=Pit2Excit(PitHz,NSamp,ExSamp,FSampHz); % Excitation has ExSamp+NSamp
[CG]=CochlGramSynt(e,FSampHz,GamCFHz);
CG=CG(:,ExSamp+1:end);

%Formanted signal
Mf=ReMa(M,NCH,NSamp);
CG=CG.*Mf;
s=sum(CG);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Mf=ReMa(M,NCH,NSamp)
%Resample  Ma
[ny,nx]=size(M);
Mp=padarray(M,[1 1]); %Matrix padded
[nyp,nxp]=size(Mp);
ex=round(NSamp/nx); ey=round(NCH/ny); %Extra x,y 
sx=nxp/(NSamp+2*ex); %We add 2*ex, to later remove
sy=nyp/(NCH+2*ey);
[Xq,Yq] = meshgrid(0.5:sx:nxp+0.5-sx,0.5:sy:nyp+0.5-sy);
Mq = interp2(Mp,Xq,Yq); %M quantize
Mf=Mq(ey+1:end-ey, ex+1:end-ex); %M final
Mf=Mf>0.41;
Mf=ChEq(Mf);




%Mf=Mf>-1;

% size(Mq), size(Mf)
% subplot(411), imagesc(M)
% subplot(412), imagesc(Mp)
% subplot(413), imagesc(Mq)
% subplot(414), imagesc(Mf)
% pause

function A=ChEq(AI)
%Channel Equalization 
%High channels have more energy because they sum more number of DFT bins. 
%With this equalization we have the same energy in all the channels
[NCH, nf]=size(AI); 
b=1.7; %Emperical 1.7
y=(0:NCH-1)*(2/(NCH-1))*(1-b)+b;
A=AI.*repmat(y',[1 nf]);    
%     subplot(311), imagesc((AI))
%     subplot(312), imagesc((A))
%     subplot(313), plot(y);
%     sum(y)
%     pause


function e=Pit2Excit(PitHz,NSamp,ExSamp,FSampHz)
%
NSampT=ExSamp+NSamp;
l=length(PitHz);
%Compute Excitation depending on the PitHz
if PitHz==-1
    e=randn(1,NSampT);    
elseif l==1   
    p=round(FSampHz/PitHz);
    e=zeros(1,NSampT); e(1:p:end)=1;   
    
elseif l>1           
    PitHz=[PitHz(1) PitHz PitHz(end)];    
    xPitHz=[1 ((1:l)-0.5)*(NSamp/l) NSamp];       
    xa=1:NSamp; 
    
    a=interp1(xPitHz,PitHz,xa,'pchip');
    
    pit=(FSampHz./a);     
    p=[pit(1)*ones(1,ExSamp) pit];    
    e=zeros(1,NSampT); e(1)=1; a=p(1);
    for i=1:NSampT
        a=a-1; if a<=0; e(i)=1; a=p(i); end
    end      
end


function [CG]=CochlGramSynt(y,FSampHz,GamCFHz)
%Cochleagram and corresponding Hilbert Envelope for Synthesis (not
%Analysis)
NCH=length(GamCFHz);
ns=length(y); 
CG=zeros(NCH,ns); 
for c=1:NCH    
    %Fast (1, half-wave-rect)
    [CG(c,:)]=gammatone_c(y,FSampHz,GamCFHz(c),0); %CGe(c,:)=env;    
    %Slow
    %CG(c,:)=gammatone(y,FSampHz,GamCFHz(c),true);   
end
