function ys=Mono2SimCircMicArray(y,yFSamp,PosAng,ysFSamp,CAP)
% Mono To Simulated Circular Microphone Array
%y:         Monaural input
%yFSamp:    SampF of y
%Pos:       Position of ys. 'LAO2' or simply 'L'
%ysFSamp:   SampF of ys
%CAP:       Circular microphone Array Parameters

%
MicRMe=CAP.MicRMe;  %Mic. Radious in Meter
MicADeg=CAP.MicADeg; %Mic Angle in Degrees
SoundSp=CAP.SoundSp;


%FUTURE: Sph2NamePos

%
ns=length(y);
nch=length(MicADeg)+1;
ys=zeros(ns,nch);

for i=1:nch-1
    de=PosAng2MicDe(PosAng,MicADeg(i),MicRMe,ysFSamp,SoundSp);
    ys(:,i)=DelSign(y,de);    
end
ys(:,nch)=y; %Last channel is the reference channel (delay=0)


%Resample yFSamp -> ysFSamp (to be done)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function yd=DelSign(y,de)
%Delay signal
ns=length(y);
yd=zeros(ns,1);
if de>=0
    yd(de+1:ns)=y(1:ns-de);
else    
    yd(1:ns-abs(de))=y(abs(de)+1:ns);
end


function de=PosAng2MicDe(PosAng,MicAng,MicRMe,FSamp,SoundSp)
%Position Angle To Microphone Delay
de=-round(FSamp*MicRMe*cos(2*pi*(PosAng-MicAng)/360)/SoundSp);





