function RunSpLocBFExample
%Run Speaker Localization and Beam Forming Example
%
% Used in papers such as:
%
% [1] Juan A. Morales-Cordovilla, Martin Hagmüller, Hannes Pessentheiner and Gernot Kubin. 
%"Distant speech recognition in reverberant noisy conditions employing a microphone array".
% EUSIPCO. 2014.
%
% [2] Juan A. Morales-Cordovilla, Hannes Pessentheiner, Martin Hagmüller, Pejman Mowlaee, Franz Pernkopf and Gernot Kubin. 
% "A German distant speech recognizer based on 3D beamforming and harmonic missing data mask". 
% AIA-DAGA, 2013
%
%The Popi localization and the DS beamforming works OK. Still to finish:
% Popi C compilation. Check Sifting Popi (I think it works), 
% Generation of CVX weights (see RT implementation, ask Hannes)


%Add paths
addpath('./SignalGen')
addpath('./SignalGen/Fun')
addpath('./SpLoc')
addpath('./SpLoc/Fun')
addpath('./BForm')
addpath('./BForm/Fun')


%Output
RD='./ResDir'; %Result Directory

%Param
P.FSamp     = 16000; %Sample Frequency
P.SoundSp   = 343; %Sound Speed
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)
P.FLSec     = 0.032; %Frame Length in Seconds
P.FSSec     = 0.010; %Frame Shift in Seconds
P.CFunDir   = './SpLoc/CFun';
P.BFormDir  = './BForm';
P           = DerivParam(P);

%Parameters of the Circular Microphone Array (CMA). We call the CMA as LA6 because we set only the polar position of the other
%microphones regarding LA6 center microphonw.
P.LA6.MicRMe=0.30;  %Microphone Radio in Meters
P.LA6.MicADeg=90+[0 -72 -72*2 72*2 72]; %Microphone Angles in Deegres
P.LA6.SoundSp=P.SoundSp; %Sound Speeed (to compute the delays)

%Simulate a multichannel speech signal at some angle position (randomly choosen) 
St=GenDirSpeech(RD,1,P.FSamp,P.LA6); ym=St.y; TruePos=St.PosAngDe;

%Circular Microphone Array Localization
[EstPos]=CircMicArrLoc(ym,RD,'S1',1,P.LA6,P);

%Beam Forming
xmonoest = BForm(ym, P.FSamp, 'ds', EstPos, P.LA6, P.BFormDir,[RD '/BFWeights']);

% Plot localization and beamforming result
fprintf('The true and estimated positions (in angle degrees) are: %d and %d\n',TruePos,EstPos);
subplot(211), plot(ym), title('Noisy multichannel')
subplot(212), plot(xmonoest), title('Clean estimation (beamforming) monochannel')










