%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  INFOS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
% Author: Hannes Pessentheiner 
% Date  : 06. July 2011 
% Update: 25. October 2011 
%
% Function: 
%   [sig, FrameCur] = cmpTimeSignal(spec,FramePre) 
%
% Function Description: 
%   This script reconstructs a signal frame from the current frame spectra
%   and the previous frame. 
%
% Input-Parameters: 
%   (array) spec        ... signal/audio frame in frequency domain (len: N)
%   (array) FramePre    ... previous frame in time domain (len: 2N) 
%
% Output-Parameters: 
%   (array) sig         ... signal/audio frame in time domain (len: N)
%   (array) FrameCur    ... current frame in time domain (len: 2N) 



function [sig,FrameCur] = cmpTimeSignal(spec,FramePre) 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
% Restore the upper part of the frame spectrum. 
lenSpec   = length(spec);
lenFrame  = 2*lenSpec;
FramePre  = FramePre(:); 

spec(1:lenSpec) = spec;
spec(lenSpec+1) = 0;
spec(lenSpec+2:2*lenSpec) = conj(spec(lenSpec:-1:2));
spec = spec(:); 

% Calculate IFFT and consider frame-windowing  
n   = (0:lenFrame-1)'/(lenFrame-1); 
win = sin(pi*n); 
FrameCur = win .* ifft(spec);

% Do reconstruction using the second half of the previous frame  
% and the first half of the current frame. 
sig = FrameCur(1:lenSpec,1) + FramePre(lenSpec+1:2*lenSpec,1);