function zArray = BForm(xMtx, fs, BfStr, EstPosDe,CMA,PathStr,WeightDir) 
% BfString = {'ds','cvx'}
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  HEADER:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
params = [];  % Set parameters. 
% addpath([PathStr '/weights']);
%addpath([PathStr '/bf/files']); 
% addpath([PathStr '/bf/libnew']); 
%addpath([PathStr '/bf/libold']); 
%addpath([PathStr '/bf/lib']); 
%addpath([PathStr '/bf/lib/ma']); 
%addpath([PathStr '/bf/lib/ma/bf']); 


%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  DEFINITIONS:  
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
params.Ma.Basic.c                     = 343.57;                                                                      % sound veolcity 
params.Ma.Basic.nBin                  = 0.032 * fs;                                                                  % number of fft bins
params.Ma.Basic.dAngleAzim            = 1;                                                                           % angular resolution in azimuth 
params.Ma.Basic.dAngleElev            = 1;                                                                           % angular resolution in elevation 
params.Ma.Basic.AzimArray             = 0 : params.Ma.Basic.dAngleAzim : 360-params.Ma.Basic.dAngleAzim;             % azimuth angles 
params.Ma.Basic.ElevArray             = 0 : params.Ma.Basic.dAngleElev : 180;                                        % elevation angles 
params.Ma.Basic.nAzim                 = length(params.Ma.Basic.AzimArray);                                           % number of azimuth angles 
params.Ma.Basic.nElev                 = length(params.Ma.Basic.ElevArray);                                           % number of elevation angles 
params.Ma.Array.MicType               = 0; 
params.Global.Audio.InpFs             = fs;                                                                          % sampling frequency 
params.Global.Audio.OutFs             = fs;                                                                          % sampling frequency of output files  
params.Global.Audio.df                = (params.Global.Audio.OutFs)*(1/params.Ma.Basic.nBin);
params.Global.Audio.fArray            = params.Global.Audio.df : params.Global.Audio.df : params.Global.Audio.OutFs; % Due to the restriction to fs/2, only the half number of frequency bins have to be considered in weights computation. 

% BForm kind 
%if strcmpi(BfStr,'cvx')
%    BfStr = 'mnscvx'; 
%end
params.Ma.Beam.Type = BfStr; % beamformer            
SrcPosStr=['Pos' num2str(EstPosDe)];      

%Juan To Hannes position 
[Sd,Mic]=Juan2HannPos(EstPosDe,CMA);
nChannel=size(xMtx,2);
params.Ma.Beam.Sd=Sd;
params.Ma.Array.Mic=Mic;

%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
%  PROCESS: Do beamforming. 
%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                  
params.Ma.Array.nMicTotal = nChannel; 
[~, params.Ma.Beam.AngleIndexAzim]    = min(abs(params.Ma.Basic.AzimArray - params.Ma.Beam.Sd(1))); % indices of azimuth angles  
[~, params.Ma.Beam.AngleIndexElev]    = min(abs(params.Ma.Basic.ElevArray - params.Ma.Beam.Sd(2))); % indices of elevation angles 

WeigthF=[WeightDir '/' SrcPosStr 'fl' num2str(params.Ma.Basic.nBin) 'fs' num2str(fs) BfStr];
if ~exist(WeightDir,'dir');   mkdir(WeightDir); end


%try
%    load(WeigthF);
%catch 
    [CapturingResponseLinArray  ] = computeCapturingResponse (params);                                        
    [WeightsArray, ...
    params.Ma.Beam.isDependent ] = computeBeamWeights       (params, CapturingResponseLinArray);
    save(WeigthF, 'WeightsArray');
    fprintf('Saved: %s\n',WeigthF);
%end


[nSample,nChannel] = size(xMtx); 

nBin               = params.Ma.Basic.nBin; 
nBin               = nBin/2;
nFrame             = floor(nSample / nBin);
% Time Domain
SigOut             = zeros(nBin, 1); 
SigOutPre          = zeros(nBin*2, 1); 
% Frequency Domain 
SpecInp            = zeros(nChannel, nBin); 
SpecOut            = zeros(nBin, 1); 
SpecOutPre         = zeros(nBin, 1); 

for iFrame = 1:nFrame-1
    % Compute a sample index. 
    SIdx = (iFrame-1)*nBin+1; 
    
    % Determine samples of single/double frame (used for overlap). 
    FrameCurS = SIdx:SIdx+  nBin-1; % single frame (short) 
    FrameCurL = SIdx:SIdx+2*nBin-1; % double frame (long)
    
    % Convert Signal into f-Domain:  
    for iChannel = 1:nChannel
        SpecInp(iChannel,:) = cmpSpecSignal(xMtx(FrameCurL,iChannel));        
    end
    
    % Calculate weights, if beamformer is data-dependent. Therefore, flag
    % has to be set to '1', otherwise '0'. 
    SpecOut(:) = sum(WeightsArray .* SpecInp,1);

    % Convert signal into t-Domain for saving it as a wav-file. 
    [SigOut(FrameCurS), SigOutPre] = cmpTimeSignal(SpecOut, SigOutPre);

    % Save previous spectrum for overlap. 
    SpecOutPre(:) = SpecOut;
end
SigOut(FrameCurS) = SigOutPre(nBin+1:2*nBin);
zArray = SigOut;     


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [Sd,Mic]=Juan2HannPos(SrcPosDe,CMA)
%Juan To Hannes Postions
%SrcPosDe: Source Position in Degrees
%CMA: Circular Microphone Array structure
%Source 
AzimSrc=SrcPosDe; %Juan and Hannes same
ElevSrc=120; %invent elevation because not high of the source. The 0 elevation is above the CMA (CMA on the cealing, source on the floor)
Sd=[AzimSrc,ElevSrc]; 
%CMA
NMic=length(CMA.MicADeg)+1;
Mic.rArray=CMA.MicRMe*ones(NMic,1);
Mic.ElevArray=90*ones(NMic,1); %the same as Src
AzimArray=zeros(NMic,1); AzimArray(1:NMic-1,1)=CMA.MicADeg;
Mic.AzimArray=mod(AzimArray,360); %made positive 360






