function [y,x,FSamp,ns,Info]=ReNormYX(dy,dx,bn)
%Read Normalized (less +-1 double) Y (noisy) and X (Clean) signals
%y: in a microphone array, each column correspond to each microphon. 
%The last column is the averaged monosignal or the reference microphone signal.
%


% P.FSamp=16000;
% P.AMicN={'K1R' 'K1L' 'K2R' 'K2L' 'K3R' 'K3C' 'K3L' 'KA6' 'KA1' 'KA2' 'KA3' 'KA4' 'KA5' 'L1R' ... 
%             'L1C' 'L1L' 'L2R' 'L2L' 'L3R' 'L3L' 'L4R' 'L4L' 'LA6' 'LA1' 'LA2' 'LA3' 'LA4' 'LA5' 'C1R' ...
%             'C1L' 'R1R' 'R1C' 'R1L' 'B1R' 'B1L' 'B2R' 'B2C' 'B2L' 'B3R' 'B3L'};
% TempGenSig(P,1);



Ext='.wav';

fny=[dy '/' bn Ext];
fnx=[dx '/' bn Ext];



[y,FSamp]=ReSWav(fny);     
[x,FSamp]=ReSWav(fnx);
ns=length(y(:,1));

   

Info=ReInfo(dy,bn,ns); 
  



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function S=ReInfo(dy,bn,lx)
%Read Info
infof=[dy '/' bn '.txt'];
if(exist(infof,'file')==2)
    fi=fopen(infof,'r');
    C = textscan(fi,'%s \t %s \t %s \t  %s \n');
    fclose(fi);
    l=length(C{1});    
    for i=1:l        
        S(i).st=C{1}{i}; 
        S(i).en=C{2}{i}; 
        S(i).pos=C{3}{i}; 
        a=C{4}(i); 
        [pn, S(i).bn] = fileparts(a{:});   
        %S(i).WTrans=GetTrans(S(i).bn,P.BNTransDic);
        S(i).WTrans='xx';
        
    end     
else
    S(1).st='1'; S(1).en=num2str(lx); S(1).pos='-1'; S(1).bn=bn; S(1).WTrans='-1';
end




function [xo,fs]=ReSWav(fn)
%Read Stereo Wave file, fn: file name
[xs,fs]=audioread(fn); 
if (size(xs,2)==2); xo=[xs (xs(:,1)+xs(:,2))/2];
else xo=xs; end


