function Iad=HIsol2Uad(Isol,P)
%Home Isol To Uad (for all rooms). Need Isol(i).Room
NRoom=length(P.ARoomN);
Iad=zeros(NRoom,P.TempP.nf);

for i=1:NRoom
  Iad(i,:)=IsolS2IadRoom(Isol,P.FS,P.TempP.nf,P.ARoomN{i});
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Iad=IsolS2IadRoom(Isol,FS,nf,RoomN)
%Isol Structure To Isolated Activity Detection of a Room
l=length(Isol);
Iad=zeros(1,nf);
for i=1:l    
    if (Isol(i).Room==RoomN)    
        st=Isol(i).st;  en=Isol(i).en;
        st=max(1,round(st/FS)); en=min(nf,round(en/FS));   
        Iad(st:en)=1;          
    end   
end


