function RunExample
%
% Basic code of paper: Juan A. Morales-Cordovilla, Hannes Pessentheiner, Martin Hagmüller and Gernot Kubin. 
% "Room localization for distant speech recognition". 
% Interspeech. 2450-2453. ISSN: 1990-9770. Singapore, September, 2014.
%
%Run Voice Activity Detection based on Deep Neural Networks [Zhang13] for 5
%rooms and Room Localization based on different classifiers (see P.RoomLK:  Support
%Vector Machine, Neural Network, Linear Discriminative Analysis,....)
%We in ./Model we provide a models for VAD and RLoc. To obtain good results train them using your database.
%With P.Stage you can select the stages: FETr (Feature Extraction for Training), Tr (Training) or Te (Test)



%Add paths
addpath('./Utils')
addpath('./Utils/SignGen')
addpath('./Fun/Vad')
addpath('./Fun/FE1')
addpath('./Fun/FE2')
addpath('./Fun/Mat')
addpath('./Fun/RoomLoc')
addpath('./Fun/Classifier')
addpath('./Fun/Classifier/Fun')
addpath('./Fun/Classifier/DBNToolbox')
addpath('./Fun/Classifier/DBNToolbox/PreTr')
addpath('./Fun/Classifier/DBNToolbox/FineTr')


%Basic Parameters
P.RoomLK    = 'Svm'; %Room Localization Kind ('Oracle', 'MaxE', 'Nn', 'LinDa (need more data)','Svm', etc.... see UttRLoc)
P.Stage     = 'Te'; %Stage: FETr (Feature Extraction for Training), Tr (Training), Te (Test)        

%Read audio noisy (y) and clean (x) signals 
dy='./SpeechData/S1';
dx='./SpeechData/S1Clean';
do='./Results';
bn='sim1';
[ys,xs,P.FSamp,P.TempP.ns,P.Info]=ReNormYX(dy,dx,bn);

%Append more parameters
P=Param(P);

%Do training if indicated
if (strcmp(P.Stage,'Tr'));  TrDbnVadRLoc(do,bn,P); end


%Read oracle information (to evaluate results and to train)
%(very heavy so we can safe this data for future)
a=[do '/OrInfo.mat'];
if ~exist(a,'file')
    [XVad,XVadNoLoc,XUadNoLoc,XUad]=OracleInfo(ys, xs, do, bn, P);
    save(a,'XVad','XVadNoLoc','XUadNoLoc','XUad');
else
    load(a);
end

%Noisy signal (ys) to UadNoLoc (Utterance Activity Detection (using DBN Vad Zhang13) with No room  Localization)
[UadNoLoc]=DbnHUttActDet(ys,xs,do,bn,P,XVad,XVadNoLoc);

%UadNoLoc to Uad (Uad with room localization)
Uad=UttRLoc(UadNoLoc,ys,do,bn,P.RoomLK,P,XUadNoLoc,XUad);

 
%Plot results
figure(1), PlotHUad(UadNoLoc); %Uad without Room Localization (just DBN-UAD for each room)
figure(2), PlotHUad(Uad); %Uad after Room Localization
figure(3), PlotHUad(XUad); %True Uad (to compare with previous Uad)
  



  
 
 









