function P=Param(P)
%

%Model Dir
P.VadDbnMDir    ='./Models/DbnVad';
P.RoomLocMDir   ='./Models/RoomLoc';


%Parameter depending on the Stage
switch P.Stage
    
    case 'FETr'
        P.TempP.VadTrF      = 1; %Vad Train Flag 
        P.TempP.URLocTrF    = 1; %Utterance RoomLoc Train Flag
        
    case 'Tr'
        P.TempP.VadTrF      = 1; 
        P.TempP.URLocTrF    = 1; 
        
        [x,x,x]=rmdir(P.VadDbnMDir,'s');
        [x,x,x]=rmdir(P.RoomLocMDir,'s');
        
    case 'Te'
        P.TempP.VadTrF      = 0; 
        P.TempP.URLocTrF    = 0; 
        
        if ~exist([P.VadDbnMDir '/Dbn.mat'],'file') 
            fprintf('WARNING: Using default models (you can also train yours)\n');
            copyfile('./Models/OrigDbnVad',P.VadDbnMDir,'f');
            copyfile('./Models/OrigRoomLoc',P.RoomLocMDir,'f');
        end
        
        
end



%Basic Parameters
P.FLSec     = 0.032; %Frame Length in seconds
P.FSSec     = 0.010; %Frame Shift in seconds
P.NCH       = 26;   %Number of Channels for Mel
P.CepL      = 13;   %Lenth of Ceptrum. The first one correspond to C0 (~energy). If 13: [C0 C1 ....C12]
P.MF        = -7.6362;  %Min Floor in Log-Mel-Msd. You can put 0 if not sure. -7.6 for .wav speech signals with amplitude [-1,1]
P.UttLSec   = 3; %Utterance Length in Seconds
P.PhLSec    = 1/4; %Ph Lenght in Seconds (inverse of the famous [3-7] Hz) 
P.BatchSSec = 3; %Batch Size in Sec (the signal is very long 1min and is analyze by batches)
P.DilVadLFr = 50; %Dilation Vad Length (for utterance segmentation) in Frames (half second)
P.OctChN    = 30;   %Octave channels Number (30) for pitch extraction   
P.MaPitHz   = 270; %Max Pitch (Hz) (270 Hz)
P.MiPitHz   = 80; %Min Pitch (Hz) (80 Hz)

%Derived Parameters
P.FL        = P.FSamp*P.FLSec; 
P.FS        = P.FSamp*P.FSSec; 
P.BatchSFr  = round(P.BatchSSec/P.FSSec); %Batch Size in Frames
P.BatchEFr  = round(P.BatchSFr/3); %Batch Edges in Frames
P.FillFrN   = floor((1+P.FL)/P.FS); %Fill Frame Number (7)
P.UttL      = P.UttLSec/P.FSSec; 
P.PhL       = round(P.PhLSec/P.FSSec); 
P.MinMS     = exp(P.MF); 
P.FL        = P.FSamp*P.FLSec; 
P.FS        = P.FSamp*P.FSSec; 
P.N2pi      = 2^ceil(log2(P.FL*2));
P.win       = hamming(P.FL); %window for spectrogram
P.TempP.nf  = ceil((P.TempP.ns-P.FL)/P.FS); %number of frames 
P.FLFr      = round(P.DilVadLFr/2.5); %First Last Frames


%House Microphones
P.ARoomN={'K' 'L' 'R' 'C' 'B'};               
P.ARoomRefMicN={'KA6' 'LA6' 'R1C' 'C1R' 'B2C'};
P.AMicN={'K1R' 'K1L' 'K2R' 'K2L' 'K3R' 'K3C' 'K3L' 'KA6' 'KA1' 'KA2' 'KA3' 'KA4' 'KA5' 'L1R' ... 
            'L1C' 'L1L' 'L2R' 'L2L' 'L3R' 'L3L' 'L4R' 'L4L' 'LA6' 'LA1' 'LA2' 'LA3' 'LA4' 'LA5' 'C1R' ...
            'C1L' 'R1R' 'R1C' 'R1L' 'B1R' 'B1L' 'B2R' 'B2C' 'B2L' 'B3R' 'B3L'};
P.MicPairLa.K={{'K1R' 'K1L'}, {'K2R' 'K2L'}, {'K3R' 'K3C'}, {'KA4' 'KA6'}};
P.MicPairLa.L={{'L1C'  'L1L'}, {'L2R'  'L2L'}, {'L3R'  'L3L'}, {'L4R'  'L4L'}, {'LA3'  'LA6'}};
P.MicPairLa.R={{'R1R' 'R1C'}, {'R1C' 'R1L'}};
P.MicPairLa.C={{'C1R' 'C1L'}};
P.MicPairLa.B={{'B1L' 'B1R'}, {'B2C' 'B2R'}, {'B3R' 'B3L'}};        
        

        
        