function HFeat=HVadFeat(ys,xs,do,bn,P,kind)
%House Vad Feat
NRoom=length(P.ARoomN); 

HFeat=[];
rys=All2MicSign(ys,P.AMicN,P.ARoomRefMicN); 
rxs=All2MicSign(xs,P.AMicN,P.ARoomRefMicN);
for i=1:NRoom     
  fprintf('Vad features for room: %d\n',i); 
  Feat=RoomFeat(rys(:,i), ys, P.ARoomN{i}, kind, P, rxs(:,i), xs);    
  HFeat=[HFeat; Feat];
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [F]=RoomFeat(y, ys, Room, kind, P, x, xs)
%Room Vad Feat



switch kind
    case 'f' %feat        
        F=ClFeat(y, ys, Room, P, x, xs);
    
    case 's' %spectrum
        [My nf]=Segmx(y,P.FL,P.FS);
        Y=Msd(My,'x',P.N2pi,P); 
        F=[log(Y)];     

        
        
end




function F=ClFeat(y, ys, Room,  P, x, xs)
%Classical

%0
[Fby,py]=BlockEnh(y,ys,P.TempP.nf,Room,P,x,xs);

%1
Ams=JuanAMS(Fby,P.FLSec, P.FSSec, P.FSamp,P); %Ams:135
[RastaPlpSpec,Lpc]=JuanRastaPlp(Fby,P.FSamp); %Lpc:12

%2
Fby8=SmoothTime(Fby,8);
Fby16=SmoothTime(Fby,16);
Cy=Fbank2Cepst(Fby,-1,P.CepL,0,1,0);
Cy8=SmoothTime(Cy,8);
Cy16=SmoothTime(Cy,16);
F=[py; Fby; Fby8; Fby16; Cy; Cy8; Cy16; Lpc; RastaPlpSpec; Ams];

% subplot(611), plot(py),     xlim([1 length(py)]), title('py')
% subplot(612), imagesc(Fby), title('Fby')
% subplot(613), imagesc(Cy),  title('Cy')
% subplot(614), imagesc(Lpc), title('Lpc')
% subplot(615), imagesc(nthroot(RastaPlpSpec,3)), title('RastaPlpSpec')
% subplot(616), imagesc(Ams), title('Ams')
% pause


