function [Snr,SnrPerAd]=HUad2Snr(Uad,ys,P)
%YE: noisy energy in 1amplitud/1sample (for each frame)

Y=HSelMicE(ys,P.ARoomRefMicN,P); %Home Ref Microphone Energy
%[Y]=HUad2Fad(Uad,Y);

N=HUadY2NEst(Uad,Y,P.FLFr);
X=Y-N; 

% figure(1), PlotHUad(Uad);
% figure(2), PlotHUad(Y);
% figure(3), PlotHUad(N);
% pause

n=X<=0; mi=min(X(~n)); if ~isempty(mi); X(n)=mi; end
n=N<=0; mi=min(N(~n)); if ~isempty(mi); N(n)=mi; end
Snr=20*log10(X./N);



[SnrPerAd]=HSnrPerTh(Uad,Snr,0); %SNR Percentage of the Th


%%%%%%%%%%%%%%%%%%%%%% Snr Percentage %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [P]=HSnrPerTh(Uad,Snr,Th)
%Home Snr Percentage over the Th

[NRoom nf]=size(Uad);
P=zeros(NRoom,nf);
for i=1:NRoom
    P(i,:)=SnrP(Uad(i,:),Snr(i,:),Th);    
end

function P=SnrP(Uad,Snr,Th)
%Uad Energy of One Room
%E: is in Amplitud. E=sqrt(mean((My.^2))); 
P=zeros(1,length(Uad));
[ai,di]=FindAscDesc1(Uad); %Mean for 1
for i=1:length(ai); int=ai(i):di(i); P(int)=mean(Snr(int)>Th); end
[ai,di]=FindAscDesc1(not(Uad)); %Mean for 0
for i=1:length(ai); int=ai(i):di(i); P(int)=mean(Snr(int)>Th); end




%%%%%%%%%%%%%%%%%%%%%%% Noise Estimation %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function N=HUadY2NEst(Uad,Y,FLFr)
%Home Uad and Y (noisy amplitude energy) 2 N Estimation
[RoomN,nf]=size(Uad);
N=zeros(RoomN,nf);
for i=1:RoomN    
    N(i,:)=Uad2NEst(Uad(i,:),Y(i,:),FLFr);      
end

function N=Uad2NEst(Uad,Y,FLFr)
%Noise Estimation
N=IntMKnownP(Y,not(Uad),FLFr); N(not(Uad))=Y(not(Uad));



