function MCC=HMicCC(ys,P)
%Home Microphone Cross Correlation signal

RoomN=length(P.ARoomRefMicN);
nf=P.TempP.nf;
MCC=zeros(RoomN,nf);

for i=1:RoomN    
    Room=P.ARoomN{i};
    a=MicCCFun(ys,P.MicPairLa.(Room),nf,P);
    MCC(i,:)=mean(a,1);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function MicCC=MicCCFun(ys,MicPairLa,nf,P)
%Microphone Cross-Corr
PairN=length(MicPairLa);
la=zeros(PairN,nf);
for i=1:PairN 
    la(i,:)=MicCC1Pair(ys,MicPairLa{i}{1},MicPairLa{i}{2},P);
end
if(PairN>1);  MicCC=max(la);
else MicCC=la; end




function la=MicCC1Pair(ys,MicLa1,MicLa2,P)
%Log-Amplitude
y=All2MicSign(ys,P.AMicN,{MicLa1,MicLa2});
[My1 nf]=Segmx(y(:,1),P.FL,P.FS);
[My2 nf]=Segmx(y(:,2),P.FL,P.FS);
%m0=JuanMagFeat1(My1,My2,P);
m0=JuanMagFeat2(My1,My2,P);
%m0=MartinMagFet(My1,My2,P);
p=m0>0; mi=min(m0(p)); if ~isempty(mi); m0(~p)=mi; end
%la=20*log10(m0);
la=m0;

function m0=JuanMagFeat1(My1,My2,P)
%
m0=sqrt(mean(My1.*My2));

function m0=JuanMagFeat2(My1,My2,P)
%
[Cb,x,x,x] =M2CC(My1,My2); 
m0=sqrt(max(Cb));


function m0=MartinMagFet(My1,My2,P)
%
Y1=Msd(My1,'x',P.N2pi,P); Y2=Msd(My2,'x',P.N2pi,P);
C=real(ifft(Y1.*Y2));
m0=C(1,:);




