function [sound_new]  = MartinAMSELEnh(x,fs,fLow,fUp,Delay,comp,bias)
% RASTA noise supression for Electrolarynx
%--------------------------------------------
% usage:[sound_new]  = EL_rasta_func(sound,fs,den,num);
%
% INPUT:
%   x ... input sound
%   fs0   ... sampling frequency
%   den   ... denominator of modulation filter
%   num   ... numerator of modulation filter
%  Dependencies:
%   Signal Processing Toolbox
%   rasta.m
%
%  (c) 2007 Martin Hagmueller  Graz University of Technology
%  hagmueller@tugraz.at

%% Pre-Processing
len = length(x);
%% get processing frame length ----------------------------
fralen  = round(0.025*fs);
halfsize = floor(fralen/2);
framelength = 2*halfsize + 1;	% force frame length to be odd
halfupdate = floor(fralen/16);
update = 2*halfupdate +1;			% force update rate to be odd
beginloop = max(halfupdate, halfsize+1);
endloop = len - max(halfsize,update);
window = (hann(framelength));

sound_new  = 0.0000001*randn(len,1);
cnt = 0;
%% RASTA Filter Design

FiltLen = round(Delay *fs/update);
%% RASTA Filter
[numer,denom] = butter(1,[fLow fUp]./((fs/update)/2));
numer = impz(numer,denom,FiltLen); 
denom = 1;

z = zeros((max(length(numer),length(denom))-1),1);
%% Processing loop


for l = beginloop: update : endloop,
  cnt = cnt+1;
  frame = x(l-halfsize:l+halfsize);
  frame = (frame).* window;
  Frame = fft(frame);
  %% RASTA Processing
  Frame_abs =   sqrt(Frame.*conj(Frame));			% Absolute Value
  Frame_ang = angle(Frame);		% Phase
  [Frame_abs,z] = filter(numer,denom,(Frame_abs).^(comp)+bias,z,2); % Frame_abs = Frame_abs(:,1);

  Frame_abs = Frame_abs-bias;
  Frame_ang(Frame_abs<0) = pi*(1+rand(length(Frame_abs(Frame_abs<0)),1));
  Frame_abs(Frame_abs<0) = 0.0001*abs(rand(length(Frame_abs(Frame_abs<0)),1));
  Frame_abs = real(((Frame_abs).^(1/comp)));
  Frame = (Frame_abs).*exp(j*(unwrap(Frame_ang)));
  frame_new = (ifft(Frame,'symmetric'));% inverse FFT
  %----------------------------------------------------------
  sound_new(l-halfsize:l+halfsize) = sound_new(l-halfsize:l+halfsize) +   ...
  frame_new(1:framelength);%.*window;
 end

sound_new = MartinDynCompr(sound_new);
sound_new = (sound_new./(max(abs(sound_new)))).*0.9999;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function y = MartinDynCompr(x)
% usage: y = dyn_compr(x)
% apply dynamic range compression on input signal
FiltLen = 20;

    a = 0.9;
    comp = -0.5;
 %   keyboard
    B = fir1(FiltLen,0.01);
%    h=filter([(1-a)^2],[1.0000 -2*a a^2],abs(x));
    h=filter(B,1,abs(hilbert(x)));
    h=h./max(max(h));
    h = [h(FiltLen+1:end,:); 0.0001*rand(FiltLen,size(x,2))];
    h=h.^comp;
    h = min(h,5);
    y=x.*h;
    y=y*(max(abs(x))/max(abs(y)));



