function [spectra,lpcas] = JuanRastaPlp(Fby,FSamp)
%[cepstra, spectra, lpcas] = rastaplp(samples, sr, dorasta, modelorder)
%
% cheap version of log rasta with fixed parameters
%
% output is matrix of features, row = feature, col = frame
%
% sr is sampling rate of samples, defaults to 8000
% dorasta defaults to 1; if 0, just calculate PLP
% modelorder is order of PLP model, defaults to 8.  0 -> no PLP
%
% rastaplp(d, sr, 0, 12) is pretty close to the unix command line
% feacalc -dith -delta 0 -ras no -plp 12 -dom cep ...
% except during very quiet areas, where our approach of adding noise
% in the time domain is different from rasta's approach 
%
% 2003-04-12 dpwe@ee.columbia.edu after shire@icsi.berkeley.edu's version
% The output can be: [cepstra, spectra, pspectrum, lpcas, F, M]


nf=size(Fby,2);
sr = FSamp; %Sample Rate (16000)
modelorder=11; %(12)
CepN=8;  %<modelorder+1 (8)
dorasta=1; %do rasta (1)
nfilts = 17; %(21)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% % % First compute power spectrum
% wintime = FLSec; %(0.025)
% steptime = FSSec; %(0.010)
% pspectrum=powspec(samples, sr, wintime, steptime); 
% pspectrum=NFCorr(pspectrum,nf);
% aspectrum = audspec(pspectrum, sr, nfilts); 

%
aspectrum = exp(Fby);

%
if dorasta ~= 0
  % put in log domain
  nl_aspectrum = log(aspectrum);
  % next do rasta filtering
  ras_nl_aspectrum = rastafilt(nl_aspectrum);  
  % do inverse log
  aspectrum = exp(ras_nl_aspectrum);
end
  

% do final auditory compressions
postspectrum = postaud(aspectrum, sr/2); % 2012-09-03 bug: was sr



  % LPC analysis 
  lpcas = dolpc(postspectrum, modelorder);   lpcas=NFCorr(lpcas,nf);    
  % convert lpc to cepstra
  cepstra = lpc2cep(lpcas, CepN);  
  % .. or to spectra
  [spectra,F,M] = lpc2spec(lpcas, nfilts); 
  
  
%   subplot(211), imagesc(log(spectra)),
%   subplot(212), imagesc(nthroot(lpcas,3))
%   pause


cepstra = lifter(cepstra, 0.6);




