function [Ams] = JuanAMS(Fby, FLSec, FSSec, FSamp, P)
%

%Param
AmsFLSec=0.0320;      %0.0320
NBand=3;            %Number of Band in the Mel   
NAmsCh=15;          %Start, end fft freq and n of Ams Channels

%Derived Param
AmsFL=round(AmsFLSec*FSamp);
AmsFftN = 2^ceil(log2(AmsFL*2)); %Always 2*AmsFL 2-power
st=1; ed=round((27/256)*AmsFftN); 
FS=(FSSec*FSamp); 
FL=(FLSec*FSamp);

%
nfo=size(Fby,2); ly=FS*nfo+FL;
CGe=Fby2CGe(Fby,ly,NBand,FS,FSamp,P.N2pi,P.MF);
%CGe2=AmsCGEnv(y,NBand,FLSec,FSamp);

%AMS
nf=ceil((ly-AmsFL)/FS);
FftMixM = GetFftMixM(AmsFftN,st,ed,NAmsCh); %FFT Mixing Matrix
Ams = zeros(NBand*NAmsCh,nfo);
AmsWin = window(@hann,AmsFL);
RepAmsWin = repmat(AmsWin,1,NBand);

for n=1:nf        
    si=FS*(n-1); 
    CGeFr = CGe(:,(si+1):(si+AmsFL));    
	RawAms1Fr = abs(fft(CGeFr'.*RepAmsWin,AmsFftN))/sqrt(AmsFL); %ams=256*26  
    
	RawAms1Fr = FftMixM*RawAms1Fr(1:AmsFftN/2,:); %ams=15*26 ; parameters.FftMixM=15*128
	Ams(:,n) = reshape(RawAms1Fr',[],1);	    
end



Ams=nthroot(Ams,3);
Ams=AppDelt(Ams,NBand,NAmsCh);

% subplot(211), imagesc(log(CGe));
% subplot(212), imagesc(log(RealignAms(Ams,NBand,NAmsCh)));
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CGe=Fby2CGe(Fby,ly,NBand,FS,FSamp,N2pi,MF)
%
Y=MelMsd2Msd(exp(Fby),FSamp,N2pi,'1');
MelM=exp(SmoothFreqCompr(Y,NBand,FSamp,N2pi,MF));
nf=size(Fby,2);
CGe=zeros(NBand,ly);
i=1:ly;
j=1+round(i/FS); j=min(j,nf);
CGe(:,i)=MelM(:,j);



function CGe=AmsCGEnv(y,NBand,FLSec,FSamp)
%
%Mel every sample and downsampling
ESSec=1/FSamp;  %Envelope Shift in Seconds (usually every 1 samples)
FBPar = JuanAMS_init(FLSec*FSamp,64,ESSec,NBand,FSamp); %64 isn't used in this routine
CG = FB_filter(y, FBPar); % CochleaGram %x=853080*1; X_sub=26*853080
CGe= env_extraction(CG, FBPar); %Cochlegram Envelope; NCH*nframes=26*213270


function B=RealignAms(A,NBand,NAmsCh)
%Realign (Reordernar) Amplitude Modulation Spectrogram
B=zeros(size(A));
for i=1:NBand
    B((i-1)*NAmsCh+1:i*NAmsCh,:)=A(i:NBand:end,:);    
end


function FftMixM = GetFftMixM(AmsFftN,st,ed,nCh)
%FFT MF->Selected Modulation Frequency Transformation
%st ed: starting and end fft points (1,27)
%nCh:   n of Channels (15)
step = (ed-st)/(nCh+1);
centers = st + (1:nCh)*step;
slope = 1/step; % slope of triangular filter
FftMixM = zeros(nCh,AmsFftN/2);
for n=1:nCh
	for i = ceil(centers(n)-step):floor(centers(n))
		FftMixM(n,i) = slope*(i-centers(n))+1;
	end
	for i = ceil(centers(n)):floor(centers(n)+step)
		FftMixM(n,i) = -slope*(i-centers(n))+1;
	end
end

function B=AppDelt(A,NBand,NAmsCh)
%Append Deltas
[nch nf]=size(A);
%Temporal
AT=A(:,2:nf)-A(:,1:nf-1); 
AT=[A(:,2)-A(:,1) AT];
%Freq
AF=A(2:nch,:)-A(1:nch-1,:);
AF=[A(2,:)-A(1,:); AF];
for i=0:NAmsCh-1
    j=i*NBand+1;
    AF(j,:)=A(j+1,:)-A(j,:); 
end
% subplot(311), imagesc(nthroot(A,3))
% subplot(312), imagesc(nthroot(AT,3))
% subplot(313), imagesc(nthroot(AF,3))
% pause
B=[A;AT;AF];


