function Y=MelMsd2Msd(MelMsd,FSamp,N2pi,k)
%From Mel to Frequency Matrix
%MelMsd:    the exp(Fby)
%N2pi:      NFFT points [0 2pi]
%Y:         follows Msd2 length (N2pi even or not)
%Mel':      can be considered inverse of Mel matrix


%
[NCH nf]=size(MelMsd);
FStart=64;
[Mel, cb]=MelFB(FStart,FSamp,N2pi,NCH);

%
if (k=='1')
    Y=Inversion1(MelMsd,Mel,cb);
else
    Y=Inversion2(MelMsd,Mel,cb);
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Y=Inversion1(MelMsd,Mel,cb)
%2 Option (true inversion) (good for Fby)
%(energy bands are correct) 
w1=sum(Mel,2); w2=sum(Mel,1); F=(w1*w2); %w1 is a column and w2 a row
Y=(Mel./F)'*MelMsd;
f=1:cb(2)+1; lf=length(f); Y(f,:)=repmat(MelMsd(1,:)/lf,[lf 1]);

function Y=Inversion2(MelMsd,Mel,cb)
%1 Option (Fby only expanded) (good for mask)
%(energy bands are not correct)
s=sum(Mel); ws=repmat(s',[1 size(MelMsd,2)]); 
Y=(Mel'*MelMsd)./ws;
f=1:cb(2)+1; lf=length(f); Y(f,:)=repmat(MelMsd(1,:),[lf 1]);



