function  [Rb, Ru, Rosab, Rosau] =M2AC(M)
%Segmented Matrix To AutoCorrelation
%M: segmented Matrix of the signal 
%Rb:    Ac all biased
%Rosab: Ac OSA (One Side Autocorrelation) biased 
%Rosau: Ac OSA (One Side Autocorrelation) unbiased

[FL nf]=size(M);



%Using fft (very fast)
x_pad = [M; zeros(FL,nf)]; 
X_psd = fft(x_pad).*conj(fft(x_pad))/FL;
r_xx = ifft(X_psd); 
Rosab=r_xx(1:FL,:); Rosau=Bi2UnOsa(Rosab);
Rb=[Rosab(FL:-1:2,:); Rosab]; 
Ru=[Rosau(FL:-1:2,:); Rosau]; 

% %To Check, Using xcorr (very slow)
% R=zeros(2*FL-1,nf); for i=1:nf; x=M(:,i); R(:,i)=xcorr(x,x,'unbiased');end, Rosa=R(FL:end,:);
% for i=1:nf; i,plot(Rosa(:,i)), hold on, stem(Rosau(:,i),'r'), hold off, pause; end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Ru=Bi2UnOsa(Rb)
%From Biased to Unbiased an Osa
[FL nf]=size(Rb);
w=FL./(FL:-1:1)'; w=repmat(w,1,nf); Ru=Rb.*w;
