function py=AcPitch(My,P,Mx) 
%Autocorrelation Pitch with smoothing (Good for Clean Speech)
%HTh=0.60; %0.70 Harmonicity Threshold
%SnrTh=3; %3 dB, SNR Thr
%HFL=4;  %4 half filter length for pitch mean
%Int=6/5; %6/5 pitch interval of search around mean ([1,2])
% P.MaPitHz P.MiPitHz P.FSamp

HTh=0.60;
SnrTh=3;
HFL=4;
Int=6/5;


[py]=AcPit(My,P,HTh,SnrTh,HFL,Int);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ps]=AcPit(M,P,HTh,SnrTh,HFL,int)
%Parameters, Segmentation, Autocorr
fa=P.MaPitHz ; fb=P.MiPitHz; %Hz
poa=round(P.FSamp/fa)+1; pob=round(P.FSamp/fb)+1;

[xx, xx, Rb, Ru]=M2AC(M);
nf=size(M,2);

%p: pit raw from ac 
[m p]=max(Rb(poa:pob,:)); p=p+poa-2;
pin=sub2ind(size(Ru),p+1,1:nf); 

%Harmonicity and SNR and VAD
H=Ru(pin)./Ru(1,:); %H=MeanF(H,HUttLFr/5);
E=Ru(1,:);
N=JuanMinStatN(E);
SNR=10*log10(E./N);

%v=(H>HTh|SNR>SnrTh); 
v=(SNR>SnrTh); 

p(~v)=0;

%Smooth pit
ps=SmVADPit(p,Rb,HFL,int,'n');

%  2
%  subplot(411), plot(E), hold on, plot(N,'r'), hold off
%  subplot(412), plot(H), hold on, plot(HTh*ones(1,nf),'r'), hold off
%  subplot(413), plot(SNR), hold on, plot(SnrTh*ones(1,nf),'r'), hold off
%  subplot(414), plot(ps), hold on, plot(p,'ro'), hold off
%  pause


function No=JuanMinStatN(Eo)
%E is in power (r(0)) and not in amplitude
%hl:half length
%
nf=length(Eo);
E=sqrt(Eo);
mu=mean(E);

%N=mu;
N=mu+2*std(E(E<mu));

No=(N*ones(1,nf)).^2;


