function [XN, MeX, StX]=MeStdNorm(X,MeX,StX)
%Mean and Std Normalization

fprintf('Normalizing...');


if nargin==1
    MeX = mean(X,2);     
    StX = std(X,0,2);
end

[ss sn]=size(X); %sample number and sample size
XN=single(zeros(ss,sn));


%Check Data
i=StX==0;
if sum(i)>0
    fprintf('WARNING in MeStdNorm: some values of standard deviation StX replaced by 1 cause they are 0\n');
    StX(i)=1;
end

%Normalize
for s=1:sn        
    XN(:,s)=(X(:,s)-MeX)./StX;
end


fprintf('normalized.\n');
