function Y=JuanClassify(X,TrueY,FN,ClDir,Tr,kind)
%Juan Classify
%X:  Data (Feat*nf)
%Y:  Class probability (ClassN*nf) 


% subplot(211), imagesc(X)
% subplot(212), imagesc(TrueY)
% pause

if (Tr)         
    Y=TrueY;        
    i=sum(Y)~=1;   if sum(i)~=0; fprintf('WARNING in Classify: some TrueY does not sum probability 1\n'); end     
    WriteHTKF([FN '.Feat'], X, 0, 1);
    WriteHTKF([FN '.ClPr'], TrueY, 0, 1);           
else    
    
    
ClF=[ClDir '/' kind];
       
    
[X,ClS]=NormXLoCl(X,ClF);

    if isempty(X);
        Y=0;
    else
        fprintf('Classif. of %d samples with %s\n',length(X),ClF); 

        switch kind  
            case 'Dbn'
              Y=DbnCl(X,ClS);       
            case 'Nn'
              Y=NnCl(X,ClS);  
            case 'LinDa'
              Y=DaCl(X,ClS,'linear');       
            case 'QuadDa'    
              Y=DaCl(X,ClS,'quadratic'); 
            case 'Svm'
              Y=SvmCl(X,ClS);    
        end   
  
    end
      
end 




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ClPr]=DbnCl(X,ClS)
%Deep belief network Classifier
XT=X';
YT=randn(size(XT,1),ClS.size(end))>0; %generate a rand output with same number of output neuros (nn.n)
ClS=nnff(ClS,XT,YT);
ClPr=(ClS.a{end})'; %last neurons output (class posterior)



function [ClPr]=NnCl(X,ClS)
%
ClPr=ClS(X);

function [ClPr]=DaCl(X,ClS,type)
%Discriminative analysis Classifier
[C,err,P,logp,coeff] = classify(X',ClS.X,ClS.Y,type);
ClPr=Cl2ClPr(C',ClS.ncl);

function [ClPr]=SvmCl(X,ClS)
%
ncl=ClS.ncl;
nf=size(X,2);
xdata=X';
ClPr=zeros(ncl,nf);
for i=1:ncl    
    a=svmclassify(ClS.Svm(i),xdata,'ShowPlot',false);
    ClPr(i,:)=a';
end

% species = svmclassify(svmStruct,[5 2],'ShowPlot',true)
% hold on;
% plot(5,2,'ro','MarkerSize',12);
% hold off


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [NX,ClS]=NormXLoCl(X,ClMat)
%Normalize X and Load Classifier structure
S=load(ClMat); 

if ~isfield(S,'ClS'); %remove in future
    ClS=S.nn;       
    NX=MeStdNorm(X,S.Me',S.Std'); % also in trainRBMStack(X,Y,opts,P); finetuneDBN(X,Y,FTP,P);
else    
    ClS=S.ClS;     
    NX=MeStdNorm(X,S.Me,S.Std); % also in trainRBMStack(X,Y,opts,P); finetuneDBN(X,Y,FTP,P);
end



