function [nn]=DbnTr(X,Y,DBNModelDir)
%Train Deep Belief Network
%X is mean and var normalized


%Pretraining Param
PP.sizes   = [52 7 7];
PP.alpha     =   0.004; %learning rate
PP.numepochs =   100; %The more the better 
PP.initMomentum  = 0.5;
PP.momentum  =   0.9;
PP.batchsize = 100;
PP.weightcost = 1e-4;
PP.firstLayerIsGaussian = 1;
PP.plot=0;

%Fine Tune Param
FTP.numepochs =  130; %100 or 30
FTP.batchsize = 100;
FTP.plot = PP.plot;
FTP.trainPerc = 0.95; %percentage of labeled data for training (rest for validation) (0.8)
FTP.nLayer = length(PP.sizes); %use this number of layers from pre-trained RBMs
FTP.learningRate = 0.005;
FTP.activation_function = 'sigm';
FTP.output = 'softmax'; %Used only to estimate error in DbnFineTune->nntrain->nnff
%FTP.output = 'sigm'; 


%Data
DBNP.DBNModelDir=DBNModelDir;

%Training
X=X'; Y=Y';
DbnTrRBMStack(X,PP,DBNP);
[nn]=DbnFineTune(X,Y,FTP,DBNP);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function DbnTrRBMStack(X,opts,P)
%
%X: each row is a frame; each column is a feature (5000*250)
%Y: a row of labels for each frame (5000*5)
%P: Parameters

fprintf('Starting DbnTrRBMStack with X size of [%d %d]\n',size(X,1),size(X,2));

% PARAMS
modelPath = P.DBNModelDir;
%[s,m,mm] = rmdir(modelPath,'s'); 
mkdir(modelPath)


% train stack of RBMs
dbn.sizes = opts.sizes;
opts.doPlotError = opts.plot;
opts.doSaveRBMs = true;
opts.savePath = modelPath;
opts.evalInCallerString = 'clear X'; %X will be cleared from within dbntrain

%set number of samples to be an integer multiple of the minibatch size
nSample = size(X,1);
nSample = nSample - mod(nSample,opts.batchsize);
X = X(1:nSample,:);

fprintf('RBM setup and training\n')
dbn = dbnsetup(dbn, X, opts);
dbn = dbntrain(dbn, X, opts);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [nn]=DbnFineTune(X,Y,FTP,P)
% Given a stack of pre-trained RBMs, fine tune the DBN using
% backpropagation.
%X: each row is a frame; each column is a feature (5000*250)
%Y: a row of labels for each frame (5000*1)
%P: Parameters


modelPath = P.DBNModelDir;
rbmFln = [modelPath '/RBM_03.mat'];

% load RBM stack
load(rbmFln);
opts.numepochs = FTP.numepochs;
opts.batchsize = FTP.batchsize;
opts.plot = FTP.plot;
opts.trainPerc = FTP.trainPerc;
opts.nLayer = FTP.nLayer;

fprintf('Selecting first %d layers from pretrained DBNs\n',opts.nLayer);
dbn.rbm = dbn.rbm(1:opts.nLayer);
dbn.sizes = dbn.sizes(1:opts.nLayer+1);


%Compute number of Tr samples (must be multiple of minibatch) (nTest = nSample-FTP.nTrain)
%Select randomly Tr and Te files
[nSample, ClN]=size(Y);  
opts.nTrain = round(opts.trainPerc*nSample/opts.batchsize)*opts.batchsize;
rndidx = randperm(nSample);
trainidx = rndidx(1:opts.nTrain);
testidx = rndidx(opts.nTrain+1:end);
trainX = X(trainidx,:);
trainY = Y(trainidx,:);

testX = X(testidx,:);
testY = Y(testidx,:);


%unfold dbn to nn
nn = dbnunfoldtonn(dbn, ClN);
nn.activation_function = FTP.activation_function;
nn.output = FTP.output;
nn.learningRate = FTP.learningRate;



if(opts.trainPerc<1)
    fprintf('Using %f percent of data as Tr set (%d samples)\n',100*opts.trainPerc,opts.nTrain);
    opts.validation = 1;    
    nn = nntrain(nn, trainX, trainY, opts,testX,testY);  
    [er, bad] = nntest(nn, testX, testY);    
    
else
    fprintf('Using all data for training (no validation set)\n');
    opts.validation = 0; 
    nn = nntrain(nn, trainX, trainY, opts);     
    
end







