function ClTr(X,Y,ClDir,kind)
%Classifier Training
%
%do:    Directory Out
%ClDir: Classiffier Dir
%kind: 
%TrDPerc: Training Data Percentage
%TrDPerc: Training Percentage


%Normalize X
[X, Me, Std]=MeStdNorm(X);

%Check Data 
i=sum(Y)~=1; if sum(i)~=0; fprintf('WARNING in ClTr: some Y doesnt sum probability 1\n'); end     


%
TmpDir=[ClDir '/TmpDir']; [x,x,x]=rmdir(TmpDir,'s'); [x,x,x]=mkdir(TmpDir);

%Train Classifier Structure
fprintf('Doing %s training with %d samples....\n',kind,length(Y));
switch kind
    case 'Dbn'
        ClS=DbnTr(X,Y,TmpDir);
    case 'Nn'
        ClS=NnTr(X,Y,TmpDir);
    case 'LinDa'
        ClS=DaTr(X,Y,TmpDir,'linear'); 
    case 'QuadDa'
        ClS=DaTr(X,Y,TmpDir,'quadratic'); 
    case 'Svm'
        ClS=SvmTr(X,Y,TmpDir);
end
fprintf('Finished %s training....\n',kind);


%
fn=[ClDir '/' kind];
save(fn,'Me', 'Std', 'ClS');
[x,x,x]=rmdir(TmpDir,'s');
fprintf('Classifer saved in %s\n',fn);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




