function C=jtextscan(fn,fmt,uniform)
%fn: a txt file where the format of each column is fmt (e.g. '%d %f %s %s %c' ).
%fmt: read %d, %f, %c and %s (although it does not appear below)
%If uniform=1 try to put as an array of number or of words


if nargin<3
    uniform=0;
end


k=find(fmt=='%');
if iscell(fn)
    L=length(fn);    
    n=length(k);    
    A=zeros(L,n);       
    for i=1:L
        A(i,:)=sscanf(fn{i},fmt);         
    end           
    
    if uniform==1
        C=A;
    else
        C=Uni2Nonuni(A,fmt,k);
    end
     
    
else    
    fi=fopen(fn,'r');  
    A=textscan(fi,fmt);   
    fclose(fi);
    
    if uniform==1        
        C=Nonuni2Uni(A,fmt,k);
    else
        C=A;
    end
        
    
    
end









%%%%%%%%%%%%%%%%%%%%%%%%%
function C=Nonuni2Uni(A,fmt,k)
%
nc=length(k);
nr=length(A{1});
C=cell(nr,nc);
for c=1:nc
      B=A{c};     
      C(:,c)=B;    
end





function C=Uni2Nonuni(A,fmt,k)
%
nc=length(k);

C=cell(1,nc);
for i=1:nc
    f=fmt(k(i):k(i)+1);
  switch f
      case {'%d', '%f'}
          a=A(:,i);
      case {'%c'}
          a=char(A(:,i));  
  end
  C{i}=a;
end   

    
    
    