function WrTpl(TplF,S)
%
%

%
H=CompileHead(S.H,S.Seq);
%
FEAT=['//////////// Features ';
    '  Num Res  Missing   SSE    CLE   ACC   pACC  CNa CNb   Xca       Yca       Zca       Xcb       Ycb       Zcb';
S.PdbToolFe.Raw];
PSM=['//////////// Original PSM file (generated by BLAST makemat -P targetname )';
'//////////// 2017-4-25  9:9:43';
S.PSM.Raw];
PSP=['//////////// Original PSP file (generated by BLAST -b 0 -j 5 -h 0.001 -d nr90)';
'//////////// 2017-4-25  9:9:43';
S.PSP.Raw];
SS2=['//////////// Original SS2 file (generated by PSIPRED)';
'//////////// 2011-10-29  0:0:41';
S.SS2.Raw];
Hhm=['//////////// Original HHM file (generated by buildali2.pl + hhmake)';
'//////////// 2017-4-25  9:9:43';
S.Hhm.Raw];
%
EL2=cell(2,1); %Empty Line
EL3=cell(3,1); %Empty Line
C=[H; EL2; FEAT; EL3; PSM; EL3; PSP; EL3; SS2; EL3; Hhm; '//'; EL3];
WrLinF(TplF,C);

%%%%%%%%%%%%%%%%%%%%%%%%%%
function H=CompileHead(S,Seq)
%Compile Head. 
%When Tpl is derived from Tgt, PdbTool, etc.. some information is invented
%
H=cell(8,1);
%Version 1.0 
if isfield(S,'Version');    H{1}=S.Version; 
else;    H{1}='Version 1.0'; end 
%Template Name  = 1a00B
if isfield(S,'TemNa'); H{2}=['Template Name  = ' S.TemNa]; %from Tpl
else;    H{2}=['Template Name  = ' S.SeqNa]; end %from Tgt
%Chain ID = B.1-146
if isfield(S,'ChainID');    H{3}=['Chain ID = ' S.ChainID]; 
else;    H{3}=['Chain ID = _1.' num2str(S.L)]; end
%Length   = 146
H{4}=['Length   = ' num2str(S.L)]; 
%SEQRES sequence = MHLTPEEKSAVTALWGKVNVD
H{5}=['SEQRES sequence = ' Seq];
 %DSSP sequence = MHLTPEEKSAVTALWGKVNVD
if isfield(S,'DsspSeq');   H{6}=['DSSP   sequence = ' S.DsspSeq]; 
else;    H{6}=['DSSP   sequence = ' Seq]; end
%NEFF = 7.6
H{7}=['NEFF = ' num2str(S.NEFF)]; 
%Date = 2011-10-29  0:0:41
H{8}=['Date = ' S.Date]; 


