function [SS8St,SS8StN,SS3St,SS3StN]=SS8To3Cl(SS8StI,SS8StOrd,SS3StOrd)
%Secondary Structure 8 To 3 Class conversion
%Mapping from: Protein Secondary Structure Prediction with Long Short Term Memory Networks
%https://arxiv.org/pdf/1412.7828v2.pdf
%Mapping from CNF Peng: https://research.cs.washington.edu/istc/lfb/paper/nips09b.pdf
%
%FUTURE: better results with continous than states, because no
 %boundaries needed Zhang08_SP and Gao16_ErrorTorsionAngles

%SS8St spaces replaced by L (random coil), it is not completly fair: http://swift.cmbi.ru.nl/gv/dssp/
SS8St=SS8StI;
a=SS8St+0; i=a==0|a==32; %2 ASCI for space
SS8St(i)='L'; 

%Pass from SS8 To SS3
%AVal= 'HECCCHEC'; %SS3St
AKey= 'HELTSGBI'; %SS8St
AVal = 'HELLLHEL'; %SS3St C replaced by L
Pr= [0.34535   0.21781   0.19185   0.11284   0.08258   0.03911   0.01029   0.00018];

a=Key2ValDictA(SS8St,AKey,AVal);
[SS3St]=char(a);

%%Assing a number (1:8) to each SS St
SS8StN=SSSt2SSN(SS8St,SS8StOrd)'; 
SS3StN=SSSt2SSN(SS3St,SS3StOrd)';



%%%%%%%%%%%%%%%%%%%%%%%%%
function SS8StN=SSSt2SSN(SS8St,SS8StOrd)
%
NSt=length(SS8StOrd);
L=length(SS8St);
P=zeros(L,NSt);
for j=1:NSt
    i=SS8St==SS8StOrd(j);
    P(i,j)=1;
end
s=sum(P,2);
if sum(s)~=L; warning('Some SSSt not asigned'); end
SS8StN=PostM2FuzzyLabV(P)'; %FUTURE: Use One Hot





