function S=ReTgtSSAcc(C1,C,Info)
%C1: head. 'SS3:   H     E     L  | SS8:   H     G     I     E     B     T     S     L  | ACC:  Bury   Medium  Expo…'
%C: body of probabilities (only nunbers, # not included)

%Check Info
Z=strsplit(C1);
SS3StOrd=sprintf('%s',Z{2:4}); %State Order
SS8StOrd=sprintf('%s',Z{7:14});
if ~strcmp(Info.SS3StOrd,SS3StOrd)||~strcmp(Info.SS8StOrd,SS8StOrd)
    error('No HEL');    
end


%
fmt=[repmat('%f ',1,3) repmat('%f ',1,8) repmat('%f ',1,3) '%c %d'];
Z=jtextscan(C,fmt);
S.SS3Po=[Z{1} Z{2} Z{3}]'; %I think Posterior (see AccPo)
S.SS8Po=[Z{4} Z{5} Z{6} Z{7} Z{8} Z{9} Z{10} Z{11}]';
S.AccPo=[Z{12} Z{13} Z{14}]'; %Posteriror because Sum_y p(y|x)=1 (y={B,M,E})
S.Seq=Z{15}';


%derived features
S.SS3StN=PostM2FuzzyLabV(S.SS3Po');
S.SS8StN=PostM2FuzzyLabV(S.SS8Po');
S.AccStN=PostM2FuzzyLabV(S.AccPo'); %a number close to 1,2,3 means 'B','M','E' (as .tgt order)
S.RAcc=(S.AccPo'*Info.RAccMax')';

%%%%%%%%%%%%%%%%%%%%%%%%%%%




