function S=ReTgt(TgtF,k)
%

if nargin<2
    k='NoRaw';
end

%
S.Info=ReTgtInfo;

%
C=ReLinF(TgtF);
IJC=StrFindC(C,{'Original PSM','Original PSP','Original DIS','Original HHM file','Original SS3+SS8+ACC'});

%Head Info
[S.H,S.Seq,L]=ReTgtHead(C);

%
%S.SeqInt=aa2int(S.Seq); %Sequence in Integers 

%PSM
ini=IJC{1}(1)+2; fin=ini+L-1;
PSMRaw=C(ini:fin);

%PSP
ini=IJC{2}(1)+2; fin=ini+L-1;
PSPRaw=C(ini:fin);
S.PSP=ReBlastPsp(PSPRaw);

%Disorder
ini=IJC{3}(1)+2; fin=ini+L-1;
DISRaw=C(ini:fin);
S.DIS=ReDisoPred(DISRaw);


%Profile Hmm
ini=IJC{4}(1)+2; fin=3+ini+L*3;
HhmRaw=C(ini:fin);
S.Hhm=ReHhHmm(HhmRaw); 



%SS3, SS8, Acc
ini=IJC{5}(1)+3; fin=ini+L-1;
SSAccRaw=C(ini:fin);
S.SSAcc=ReTgtSSAcc(C{ini-1},SSAccRaw,S.Info.SSAcc);

%
if strcmp(k,'Raw')
    S.PSM.Raw=PSMRaw;
    S.PSP.Raw=PSPRaw;
    S.DIS.Raw=DISRaw;
    S.Hhm.Raw=HhmRaw; %Used in hhsuite align
    S.SSAcc.Raw=SSAccRaw;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [S,Seq,L]=ReTgtHead(C)
%
S.Version=C{1};
S.SeqNa=REq(C{2}); 
S.L=str2double(REq(C{3}));  L=S.L;
Seq=REq(C{4});
S.SSEseq=REq(C{5});
S.SSEconf=REq(C{6});
S.ACCseq=REq(C{7});
S.ACCconf=REq(C{8});
S.NEFF=str2double(REq(C{9}));
S.EVD=REq(C{10},'g');
S.Date=REq(C{11},'g');



function RA=REq(A,k)
%Rigth from Equal
if nargin<2;    k='n'; end
if k=='g' %mantein blank spaces (gaps)
    p=strfind(A,'=');    RA=A(p+2:end);    
else %remove gaps
    Z=strsplit(A,'='); RA=regexprep(Z{2},' +','');
end










