function SO=RePdbToolFe(fn,Info,k)
%PdbTool Feat is the first section of .tpl of RaptorX
%Info: by S=ReTgt or ReTgtInfo

if nargin<3
    k='NoRaw';
end


if iscell(fn)
    A=fn;
else
    A=ReLinF(fn); 
end

%Read
         %Num Res  Missing   SSE    CLE   ACC   pACC  CNa CNb   Xca       Yca       Zca       Xcb       Ycb       Zcb';   
         %1   W      0       L      R     1     35   3   4    110.230    30.823    34.018   111.103    30.865    32.755
fmt='%d %c     %d    %c   %c  %d   %d %d %d  %f            %f           %f         %f            %f           %f';

Raw=A(2:end);
C=jtextscan(Raw,fmt);

%
Num=C{1}'; 
Seq=C{2}';  
Missing=C{3}';   
SSE8=C{4}';    %8-class SS
CLE=C{5}';   
AccStN=C{6}';   %Pdb Tool use [0,1,2] and we use [1,2,3] for [B,M,E]
RAcc=C{7}';  % Relative Acc
CNa=C{8}'; CNb=C{9}';   
Xca=C{10}'; Yca=C{11}'; Zca=C{12}';       Xcb=C{13}';       Ycb=C{14}';       Zcb=C{15}';


%I know the dictionary
AccSt=Key2ValDictA(AccStN,[0 1 2],'BME'); %Key2ValDictA(Key,AKey,AVal,PrintError)


%
[SS8St,SS8StN,SS3St,SS3StN]=SS8To3Cl(SSE8,Info.SSAcc.SS8StOrd,Info.SSAcc.SS3StOrd);

SO.SS3Po=OneHot(SS3St,Info.SSAcc.SS3StOrd);
SO.AccPo=OneHot(AccSt,Info.SSAcc.AccStOrd);

SO.SS3St=SS3St; %FUTURE: comment because only needed by RaptTplFe
%SO.AccSt=AccSt;
SO.SS3StN=SS3StN;
SO.RAcc=RAcc;

if strcmp(k,'Raw')
    SO.Raw=Raw;
end


%%%%%%%%%%%%%%%%%%%%%%%%%












