function S=ReHhHmm(PHmmC)
%Read Hhsuite Hmm
%Hhm File in Cell (Profile Hmm of hblist+hmake) To Structure
%

C=PHmmC;
NullRow=sscanf(C{1}(5:end),'%d',[1 inf]);
AAForm=sscanf(C{2}(4:end),'%s');
b=strsplit(C{3}); b(1)=[]; 
TrForm=b(1:end-3);
NeffForm=b(end-2:end);


AAFormL=length(AAForm); %Total Number of AA
TrFormL=length(TrForm);
NeffFormL=length(NeffForm);

%
L=((length(C)-1)/3) -1;

AA=char(zeros(1,L));
StI=zeros(L,AAFormL);
TrI=zeros(L,TrFormL);
NeffI=zeros(L,NeffFormL);

for i=1:L        
    [AA(i),StI(i,:),TrI(i,:),NeffI(i,:)]=Re1HmmSt(C{(i-1)*3+5},C{(i-1)*3+6});      
end


%S.ModelSeq=AaSeq;
% S.MatchEmission=Int2Pr(StIPr);
% S.TransitProb=Int2Pr(TrIPr);
% S.NullEmission=Int2Pr(NullRow);

S.LMatchEmission=Int2LPr(StI);
S.LTransitProb=Int2LPr(TrI);
S.NeffProb=NeffI*0.001;
S.LNullEmission=Int2LPr(NullRow);
S.Alphabet = 'AA';
S.ModelLength=L;
S.Seq=AA;

%Compute PSSM
S.LPSSM=HmmProfStr2Pssm(S);
%S.PSSM=S.MatchEmission;
%S.PSSM=StIPr';

%%%
S.Pi=2.^S.LTransitProb(:,2); %Probability of insertion. I think 
%S.Pd=2.^S.LTransitProb(:,7);



%%%%%%%%%%%%%%%%%%%%%%%%%
function [AA,StPr,TrPr,Neff]=Re1HmmSt(l1,l2)
%
AA=l1(1); 
a=strsplit(l1(8:end)); StPr=str2double(a(1:end-1)); 
a=strsplit(l2(8:end)); b=str2double(a(1:end-1)); 
TrPr=b(1:end-3); Neff=b(end-2:end);


function LPr=Int2LPr(Int)
%Int: Matrix of HMM emisions
LPr=Int/-1000; 
LPr(isnan(LPr))=-Inf; %nan correspond to '*' or '99999', i.e. LPr=-Inf; Pr=0 


function Pr=Int2Pr(Int)
%Pr: [0,1] 
%In HHSuite.pdf Pr is equivalent to frequency of Eq. 6
%See also Soeding05_AliHMM says that he uses log-odds probabilities
%Int=-1000*log2(Pr)
Pr=2.^(Int/-1000); 
Pr(isnan(Pr))=0; %nan correspond to '*' or '99999', i.e. Pr=0







