function PSP=ReBlastPsp(A)
%PSSM: [-12,12]
%PSFM: [0,1]. WARNING: PSFM can be all 0s. It is bad for cosine similarity


%Read PsiBlast

L=length(A);
NAA=20;
PSP.Seq=char(1,L);
PSP.PSSM=zeros(NAA,L); 
PSP.PSFM=zeros(NAA,L);
PSP.Last2=zeros(2,L);
for i=1:L       
    b=strsplit(A{i});    b=b(2:end);      
    PSP.Seq(i)=b{2};         
    PSP.PSSM(:,i)=Str2NumC(b(3:2+NAA));   
    PSP.PSFM(:,i)=Str2NumC(b(3+NAA:2+2*NAA));           
    PSP.Last2(:,i)=[str2double(b{end-1}); str2double(b{end})];    
end

%To have PSFM [0,1]
PSP.PSFM=PSP.PSFM/10; %as explain Shibiao15_MaLeSubcellularLocalization






