function RaptTplFe(do,bn,TgtDir,PdbToolDir) 
%if TgtDir and PdbToolDir given not derived from P


% %
% if nargin < 6
%     TgtDir=[P.ExtFeDir '/Rapt/Tgt'];
%     PdbToolDir=[P.ExtFeDir '/Rapt/PdbTool'];
% end

%
jmkdir(do);

%Read Tgt 
S=ReTgt([TgtDir '/' bn '.tgt'],'Raw');




%Read RePdbTool
B=RePdbToolFe([PdbToolDir '/' bn '.feature'],S.Info,'Raw');


S.PdbToolFe.Raw=B.Raw;


%
S.SS2.Raw=GenPSIPredRaw(S.SSAcc.SS3Po',S.Seq,B.SS3St); %FUTURE: use B.SS3N

%
WrTpl([do '/' bn '.tpl'],S);




%%%%%%%%%%%%%%%%%%%%%%%%%
function C=GenPSIPredRaw(P,Seq,St)
%Input St: H (Helix,G,H),  E (Sheets,B,E), L (rest,L,C), https://research.cs.washington.edu/istc/lfb/paper/nips09b.pdf
%Output St: H=helix, E=strand, C=coil, http://capservices.ncbs.res.in/help/psipred
St(St=='L')='C'; %pass L to C
L=length(Seq);
C=cell(L,1);
for i=1:L
    n=sprintf('%4d', i);
    a = sprintf('%.3f',P(i,1));
    b = sprintf('%.3f',P(i,2));
    c = sprintf('%.3f',P(i,3));
    C{i}=[n ' ' Seq(i) ' ' St(i) '   ' a '  ' b '  ' c];    
end







