function E=OneHot(LabSeq,LabOrd,k)
%One Hot Econding/Decoding
%FUTURE create a class.encoding/decoding
%k: 'e' encoding, 'd' decoding
%LabSeq LabOrd: row vector number or  char
%E: double (not logical) cause used as posterior frequently

if nargin < 3
    k='e';
end

if k=='e'
    E=OneHotEnc(LabSeq,LabOrd);    
else
    E=OneHotDec(LabSeq,LabOrd);    
end

%%%%%%%%%%%%%%%%%%%%%%%
function LabSeq=OneHotDec(E,LabOrd)
%
[NLab,NI]=size(E);
LabSeq=zeros(1,NI);
for l=1:NLab
    LabSeq(E(l,:)==1)=LabOrd(l);
end



function E=OneHotEnc(LabSeq,LabOrd)
%
NLab=length(LabOrd);
NI=length(LabSeq); %Number of Instances
E=zeros(NLab,NI);
for l=1:NLab
    E(l,LabSeq==LabOrd(l))=1;
end


