function [Val]=Key2ValDictA(Key,AKey,AVal,PrintError)
%Key To Value using a Dictionary for Array of numbers
%AKey,AVal: vectors (dictionary) of numbers [0 1 2] or of char ['BME']
%Key,Val: big arrays (input/output)
%PrintError: 'e' 'w' 

if nargin<4
    PrintError='e';
end



%Since we usually have more Key than AKey (in text transcriptions) we do the loop for AKey
L=length(AKey);

if ischar(AVal(1))
    Val=char(zeros(size(Key)));
else
    Val=NaN(size(Key));
end


%%%
[Lia,Locb]=ismember(Key,AKey);
Val=AVal(Locb);
%%%

% %%%
% for i=1:L    
%     j=Key==AKey(i);
%     Val(j)=AVal(i);
% end
% %%%

%
i=isnan(Val);
if sum(i)>0
    switch PrintError
        case 'e'
            error('Bad transcription: some Key are not in AKey')
        case 'w'
            warning('Bad transcription: some Key are not in AKey');
        case 'n'
        case 'z'
            warning('Bad transcription: some Key are not in AKey');
            Val(i)=0;            
        otherwise
    end
end


