#!/bin/bash


# McrRoot where you have Matlab installed or Matlab-Runtime 
# (https://uk.mathworks.com/products/compiler/matlab-runtime.html)
McrRoot=/home2/Softwares/MATLAB/R2016b


# Export Matlab libraries
export LD_LIBRARY_PATH=$McrRoot/runtime/glnxa64:$McrRoot/bin/glnxa64:$McrRoot/sys/os/glnxa64:
export XAPPLRESDIR=$McrRoot/X11/app-defaults
#
McrCacheDir=/tmp/RunExample
mkdir -p $McrCacheDir;
export MCR_CACHE_ROOT=$McrCacheDir
# System libraries (maybe needed by external programs, when the Matlab libraries are olds)
# export LD_PRELOAD=/usr/lib/x86_64-linux-gnu/libgfortran.so.3:/usr/lib/x86_64-linux-gnu/libstdc++.so.6:/usr/lib/liblapack_atlas.so.3


#Input
QueSeq=SAVDMDECKEPDVCKHGQCINTDGSYRCECPFGYILAGNECVD; #Query Sequence
TemPdb=./In/1oav-d1iva.pdb; #Template Pdb 
ParamF=./In/Param.txt; #Parameter File
#Alignment Kind
AliK=Crf1; #Conditional Random Field of 1st order [Morales18]
#AliK=Crf2; #Conditional Random Field of 2nd order [Morales18]
#AliK=CnfPred; #CNFPred [Ma12]
#AliK=MatG; #Matla Global alignment function nwalign
#qs=1; qe=43;  ts=1; te=48; # (optional) query/template/start/end 


#Output
EstQuePdb=./Out/1emo-d1emo_1.pdb; #Estimated Query Pdb
EstFastaAli=./Out/1oav-d1iva@1emo-d1emo_1.fasta; #Estimated Fasta Alignment


#Execute Matlab Program
echo "Executing......"
./EstPdbAli $EstQuePdb $EstFastaAli $QueSeq $TemPdb $AliK $ParamF 
# $qs $qe $ts $te

#Delete Mcr cache dir
rm -rf $McrCacheDir




