function [LZf,LZb]=LForwBackPart(LPMI)
%Log of Forward and Backward Partition function
%
%LPM: Log(Psi) Matrix Input (scoring-function)
%LZf: log of forward partition-function
%LZb: lof backward partition-function


%Get number of row and columns of the alignment matrix (Fig. 1a)
[NSt,NSt,Lq,Lt]=size(LPMI); 
nr=Lq+1; nc=Lt+1;

%Append dummy borders to LPM  (Fig. 1a)
LPM=ones(NSt,NSt,nr,nc); 
LPM(:,:,2:nr,2:nc)=LPMI;


%Forward (eq. 3a)
LFM=-Inf*ones(NSt,nr,nc); 
for x=1:nr
    for y=1:nc
        for v=1:NSt            
            if x==1 && y==1
                LFM(v,1,1)=0;
            else
                 [LF,LP]=Forw1St1Pos(LFM,LPM,v,x,y,NSt);
                 [LFM(v,x,y)]=logsumexp(LF+LP);
            end
        end
    end
end


%Backward (eq. 3b)
LBM=-Inf*ones(NSt,nr,nc);
for x=nr:-1:1
    for y=nc:-1:1
        for u=1:NSt            
        if x==nr && y==nc
            LBM(u,nr,nc)=0;
        else            
            [LP,LB]=Back1St1Pos(LBM,LPM,u,x,y,NSt);   
            [LBM(u,x,y)]=logsumexp(LP+LB);          
        end
        end
    end
end

%Forward and backward partition functions (eq. 5)
%Note that paper (0,0) is here (1,1) because Matlab doen't allow start with 0
%LZf=LogDot(LFM(:,Lq+1,Lt+1),zeros(NSt,1)); 
LZf=logsumexp(LFM(:,Lq+1,Lt+1)); 
LZb=logsumexp(LBM(:,1,1)); 




%%%%%%%%%%%%%%%%%%%%%%%%%
function [LF,LP]=Forw1St1Pos(LFM,LPM,v,x,y,NSt)
%Forward for One State and One Position
switch v
    case 1
        xp=x-1;  yp=y-1;
    case 2 
        xp=x-1;  yp=y;
    case 3
        xp=x;  yp=y-1;
end
LF=zeros(NSt,1); LP=zeros(NSt,1);
for up=1:NSt    
    LP(up)=Ext2(LPM,up,v,x,y); 
    LF(up)=Ext1(LFM,up,xp,yp);
end


function [LP,LB]=Back1St1Pos(LBM,LPM,u,x,y,NSt)
%Bacward for One State and One Position
LB=zeros(NSt,1); LP=zeros(NSt,1);
for vp=1:NSt
    switch vp
        case 1
            xn=x+1;  yn=y+1;
        case 2
            xn=x+1;  yn=y;
        case 3
            xn=x;  yn=y+1;
    end   
    LB(vp)=Ext1(LBM,vp,xn,yn);
    LP(vp)=Ext2(LPM,u,vp,xn,yn);
end

%%%%%%%%%%%%%%%%%%%%%%%%%
function B=Ext1(A,v,x,y)
%Extract-1. Give 0 if out of matrix position
[xx,nr,nc]=size(A);
B=-Inf;
if x>0 && y>0 && x<=nr && y<=nc
    B=A(v,x,y);
end

function B=Ext2(A,u,v,x,y)
%Extract-2. Give 0 if out of matrix position
[xx,xx,nr,nc]=size(A);
B=-Inf;
if x<=nr && y<=nc
    B=A(u,v,x,y);
end


