#!/bin/tcsh


#######################################################################
set FeatIDir 	= $1 #FEAT dir where is testa/ cleanTR/ etc...
set HmmDir 	= $2 #folder of outputs files (HMM model and macro): /home/roter/RESULTS/FE511/HMM08CleanCond
set RecDir 	= $3 
set TrOpt	= "$4" #TRAIN OPTIONS (52 or 46, ..)
set TrTeDir 	= $5
set HTKROOT 	= $6
set ExtraFunRoot = $7
set AdapTok	= "$8"
########################################################################
set SNCh    	= `echo $TrOpt | awk '{print $1}'` 	# Static NCh
set Del		= `echo $TrOpt | awk '{print $2}'`	# Delete train files
set KTrain 	= `echo $TrOpt | awk '{print $3}'` 	# Kind of Train
set KRepr	= `echo $TrOpt | awk '{print $4}'`	# Kind of Repesent
set DBSize	= `echo $TrOpt | awk '{print $5}'`	# DataBase Size
set SpDep	= `echo $TrOpt | awk '{print $9}'`	# 1 means Speaker Dependent Recognition
set SDBase	= `echo $TrOpt | awk '{print $10}'`

set BN = `basename $TrTeDir`; 
set DN = `dirname $TrTeDir`;




######################## PARAMETERS ################################################
set TrainDir  	= $RecDir/TrainGen



set VSize  	= MV; # Vocabulary Size: Medium (MV for AURORA4, FBKGEDIRHA, GRAZCONV etc.) or Small (SV for AURORA2 OR GRID) Vocabulary
set Config      = $TrainDir/TrainDir/Common/Config.txt
set TempFList 	= $HmmDir/TempTrList.txt


############################################################################
set path = ($HTKROOT $path)
cp -r $HmmDir/SI $HmmDir/PrevSI
cp -r $HmmDir/PhSI $HmmDir/PrevPhSI
# rm -rf  $TempFList $HmmDir/Adapt $HmmDir/R1  $HmmDir/R2  $HmmDir/R3 $HmmDir/PhSI  $HmmDir/SI; 
mkdir -p $HmmDir;

######################################################################

if ($VSize == MV) then
  set Gaus 	= (2 3 4 5 6 8) 
  set Ext 	= Cxest
  set NCh	= `echo $SNCh + $SNCh + $SNCh | bc`     

else

  if ( $KRepr == Cep ) then
	
	if (($SDBase == CHIME) || ($SDBase == DIRHAGRID)) then
	  set Gaus	= (1 2 3 5 7)
	else #for Aurora-2
	  set Gaus	= (1 2 3)
	endif

	set Ext 	= Cxest
	set NCh 	= `echo $SNCh + $SNCh + $SNCh | bc`
  else
	set Gaus	= (1 2 3 5 7) # if preenphasis dont use 11 because at 11 iteration 2 (or 9 iteration 6) error of mean 
	set Ext 	= Fby	
	set NCh 	= `echo $SNCh + $SNCh | bc` 
  endif

endif

set FList = $TrainDir/TrainDir/$SDBase/Lists/TrListAll_{$DBSize}.txt


# awk '{printf("'$FeatIDir/Train$KTrain'/%s'.$Ext'\n", $1)}' $FList > $TempFList
awk '{printf("'$FeatIDir/$DN'/%s'.$Ext'\n", $1)}' $FList > $TempFList


########################################### Medium/Small Vocabulary #################################################################
if ($VSize == MV) then

  #$TrainDir/TrainDir/$VSize/TrainMV1.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase $SpDep 3
  #$TrainDir/TrainDir/$VSize/TrainMV2MonoPh.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase
  #$TrainDir/TrainDir/$VSize/TrainMV2.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase
  #$TrainDir/TrainDir/$VSize/TrainMV3.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase

else  


  #$TrainDir/TrainDir/$VSize/TrainSV.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase $SpDep
  #$TrainDir/TrainDir/$VSize/A2TrainSV.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase $SpDep
  
endif

############################################################################################################
if ($SpDep == 1) then

  $TrainDir/TrainDir/TrainAdapt.sh $HmmDir $TempFList $TrainDir $Config $NCh "$Gaus" $HTKROOT $SDBase $SpDep $RecDir $FeatIDir $ExtraFunRoot "$AdapTok"  

endif
############################################################################################################
rm -rf $TempFList




