#!/bin/bash




LMPrepDir=$1
IDir=$2 #wsj0_data=/home/jmorales/SpeechData/CHIME3_All/CHiME3/data/WSJ0
LMRes=$3
Param="$4"



TrKaldDir=`echo $Param | awk '{print $1}'`	
KaldiRoot=`echo $Param | awk '{print $2}'`



OrPwd=`pwd`; 
cd $TrKaldDir


#
MDir=$LMRes/MDir
DataDir=$MDir/data
mkdir -p $DataDir;

######################################################################
echo '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% clean_wsj0_data_prep.sh %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
$LMPrepDir/clean_wsj0_data_prep.sh $IDir $DataDir $KaldiRoot || exit 1; #40 sec #needed by simu_noisy_chime3_data_prep


#########################################################################
echo '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% wsj_prepare_dict.sh %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
$LMPrepDir/wsj_prepare_dict.sh $DataDir $KaldiRoot || exit 1; #3sec not need database in clean_wsj0_data_prep.sh 

 


echo '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% prepare_lang.sh %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
$LMPrepDir/prepare_lang.sh $DataDir/local/dict "<SPOKEN_NOISE>" $DataDir/local/lang_tmp $DataDir/lang $KaldiRoot || exit 1; #30 sec L_disambig.fst  L.fst  oov.int  oov.txt  phones  phones.txt  topo  words.txt




echo '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% clean_chime3_format_data.sh %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
$LMPrepDir/clean_chime3_format_data.sh $DataDir $KaldiRoot || exit 1; #30 sec G.fst


#######################################################################



# Copy outputs
 cp -r $DataDir/lang $LMRes
 cp -r $DataDir/lang_test_tgpr_5k $LMRes
 cp $DataDir/local/data/dot_files.flist $LMRes
 echo "Copied files in $LMRes"
 
# 
rm -rf $MDir;

cd $OrPwd


