#!/bin/bash

# Copyright 2012  Microsoft Corporation  Johns Hopkins University (Author: Daniel Povey)
# Apache 2.0

# This script takes data prepared in a corpus-dependent way
# in $DataDir/local/, and converts it into the "canonical" form,
# in various subdirectories of $DataDir/, e.g. $DataDir/lang, $DataDir/lang_test_ug,
# $DataDir/train_si84, etc.

# Modified from the script for CHiME3 baseline
# Shinji Watanabe 02/13/2015





DataDir=$1
KaldiRoot=$2

. ./path.sh $KaldiRoot;

echo "Preparing train and test data"
srcdir=$DataDir/local/data
lmdir=$DataDir/local/nist_lm
tmpdir=$DataDir/local/lm_tmp
lexicon=$DataDir/local/lang_tmp/lexiconp.txt
mkdir -p $tmpdir

for x in et05_orig_clean dt05_orig_clean tr05_orig_clean; do 
  mkdir -p $DataDir/$x
  cp $srcdir/${x}_wav.scp $DataDir/$x/wav.scp || exit 1;
  cp $srcdir/$x.txt $DataDir/$x/text || exit 1;
  cp $srcdir/$x.spk2utt $DataDir/$x/spk2utt || exit 1;
  cp $srcdir/$x.utt2spk $DataDir/$x/utt2spk || exit 1;
  utils/filter_scp.pl $DataDir/$x/spk2utt $srcdir/spk2gender > $DataDir/$x/spk2gender || exit 1;
done


# Next, for each type of language model, create the corresponding FST
# and the corresponding lang_test_* directory.

echo Preparing language models for test

for lm_suffix in tgpr_5k; do
  test=$DataDir/lang_test_${lm_suffix}
  mkdir -p $test
  for f in phones.txt words.txt phones.txt L.fst L_disambig.fst \
     phones; do
    cp -r $DataDir/lang/$f $test
  done
  
  

  
  
  
  
#   gunzip -c $lmdir/lm_${lm_suffix}.arpa.gz | utils/find_arpa_oovs.pl $test/words.txt  > $tmpdir/oovs_${lm_suffix}.txt # Juan
   
   gunzip -c $lmdir/lm_${lm_suffix}.arpa.gz > $tmpdir/TmpArpaUnzip
   utils/find_arpa_oovs.pl $test/words.txt $tmpdir/TmpArpaUnzip > $tmpdir/oovs_${lm_suffix}.txt
   
      
  # grep -v '<s> <s>' because the LM seems to have some strange and useless
  # stuff in it with multiple <s>'s in the history.  Encountered some other similar
  # things in a LM from Geoff.  Removing all "illegal" combinations of <s> and </s>,
  # which are supposed to occur only at being/end of utt.  These can cause 
  # determinization failures of CLG [ends up being epsilon cycles].
  gunzip -c $lmdir/lm_${lm_suffix}.arpa.gz | \
    grep -v '<s> <s>' | \
    grep -v '</s> <s>' | \
    grep -v '</s> </s>' | \
    arpa2fst - | fstprint | \
    utils/remove_oovs.pl $tmpdir/oovs_${lm_suffix}.txt | \
    utils/eps2disambig.pl | utils/s2eps.pl | fstcompile --isymbols=$test/words.txt \
      --osymbols=$test/words.txt  --keep_isymbols=false --keep_osymbols=false | \
     fstrmepsilon | fstarcsort --sort_type=ilabel > $test/G.fst
  fstisstochastic $test/G.fst
 # The output is like:
 # 9.14233e-05 -0.259833
 # we do expect the first of these 2 numbers to be close to zero (the second is
 # nonzero because the backoff weights make the states sum to >1).
 # Because of the <s> fiasco for these particular LMs, the first number is not
 # as close to zero as it could be.

  # Everything below is only for diagnostic.
  # Checking that G has no cycles with empty words on them (e.g. <s>, </s>);
  # this might cause determinization failure of CLG.
  # #0 is treated as an empty word.
  mkdir -p $tmpdir/g
  awk '{if(NF==1){ printf("0 0 %s %s\n", $1,$1); }} END{print "0 0 #0 #0"; print "0";}' \
    < "$lexicon"  >$tmpdir/g/select_empty.fst.txt
  fstcompile --isymbols=$test/words.txt --osymbols=$test/words.txt $tmpdir/g/select_empty.fst.txt | \
   fstarcsort --sort_type=olabel | fstcompose - $test/G.fst > $tmpdir/g/empty_words.fst
  fstinfo $tmpdir/g/empty_words.fst | grep cyclic | grep -w 'y' && 
    echo "Language model has cycles with empty words" && exit 1
  rm -r $tmpdir/g
done

echo "Succeeded in formatting data."
rm -r $tmpdir
