#!/bin/bash



GmmDir=$1
LMPrepDir=$2
LMRes=$3
InfoDir=$4
GmmRes=$5
Param="$6"


TrKaldDir=`echo $Param | awk '{print $1}'`	
KaldiRoot=`echo $Param | awk '{print $2}'`
FeatType=`echo $Param | awk '{print $3}'` 
TotGDelt=`echo $Param | awk '{print $4}'`  
TotGLdaSat=`echo $Param | awk '{print $5}'`  



echo "TotGDelt: $TotGDelt"


OrPwd=`pwd`; 
cd $TrKaldDir

enhan=enhanced
train=tr05_multi_$enhan

lang=$LMRes/lang #DataDir/lang
langtest=$LMRes/lang_test_tgpr_5k

MDir=$GmmRes/MDir
DataDir=$MDir/data
ExpDir=$MDir/exp


mkdir -p $DataDir/$train


MfccTrInfoDir=$InfoDir/MfccTrInfoDir
cp $MfccTrInfoDir/CmvnScp.txt $DataDir/$train/cmvn.scp 
cp $MfccTrInfoDir/FeatScp.txt $DataDir/$train/feats.scp 
cp $MfccTrInfoDir/Spk2Utt.txt $DataDir/$train/spk2utt 
cp $MfccTrInfoDir/Utt2Spk.txt $DataDir/$train/utt2spk 
cp $MfccTrInfoDir/Text.txt    $DataDir/$train/text 


# Split as speaker number
nj=1
spk2utt=$DataDir/$train/spk2utt 
nspk=`wc -l $spk2utt | awk '{print $1}'`
if [ $nj -gt $nspk ]; then
  nj2=$nspk
else
  nj2=$nj
fi  


 
###########################################################################################
echo "#################################MonoPhones################################"
$GmmDir/train_mono.sh --boost-silence 1.25 --nj $nj2 $DataDir/$train $lang $ExpDir/mono0a_$train $FeatType $KaldiRoot || exit 1; #1 min


echo "################################Deltas################################"
$GmmDir/align_si.sh --boost-silence 1.25 --nj $nj2 $DataDir/$train $lang $ExpDir/mono0a_$train $ExpDir/mono0a_ali_$train $FeatType $KaldiRoot $TrKaldDir || exit 1; #15 sec
$GmmDir/train_deltas.sh --boost-silence 1.25 2000 $TotGDelt $DataDir/$train $lang $ExpDir/mono0a_ali_$train $ExpDir/tri1_$train $FeatType $KaldiRoot || exit 1; # 30 sec


echo "#################################LDA################################"
$GmmDir/align_si.sh --nj $nj2 $DataDir/$train $lang $ExpDir/tri1_$train $ExpDir/tri1_ali_$train $FeatType $KaldiRoot $TrKaldDir || exit 1; #20 sec
$GmmDir/train_lda_mllt.sh --splice-opts "--left-context=3 --right-context=3" 2500 $TotGLdaSat $DataDir/$train $lang $ExpDir/tri1_ali_$train $ExpDir/tri2b_$train $FeatType $KaldiRoot || exit 1; #20 sec


echo "#################################SAT################################"
$GmmDir/align_si.sh  --nj $nj2 --use-graphs true $DataDir/$train $lang $ExpDir/tri2b_$train $ExpDir/tri2b_ali_$train  $FeatType $KaldiRoot $TrKaldDir || exit 1; #1sec
$GmmDir/train_sat.sh 2500 $TotGLdaSat $DataDir/$train $lang $ExpDir/tri2b_ali_$train $ExpDir/tri3b_$train $FeatType $KaldiRoot || exit 1; #15 sec




# ###################################### NEXT: REPLACED FULLY BY MATLAB #####################
# # ############################### Make Graph ############################################################
#   GmmTrDir=$ExpDir/tri3b_$train
#  # GmmTrDir=$ExpDir/tri1_$train
#  $LMPrepDir/mkgraph.sh $langtest $GmmTrDir $GmmTrDir/graph_tgpr_5k $KaldiRoot $TrKaldDir || exit 1; # 7 min FUTURE: this and cp final do in matlab
# # ###########################################################################################
# 
# # Copy Final Outputs
# mkdir -p $GmmRes/4Dnn
# cp $GmmTrDir/* $GmmRes/4Dnn
# 
# 
# mkdir -p $GmmRes/FinalGmm 
# cp $GmmTrDir/final.mat $GmmTrDir/graph_tgpr_5k/HCLG.fst $GmmRes/FinalGmm
# 
# #Special case of mdl
# if [ -f $GmmTrDir/final.alimdl ]; then 
#   cp $GmmTrDir/final.alimdl $GmmRes/FinalGmm; 
# else 
#   mv $GmmTrDir/35.mdl $GmmRes/FinalGmm/final.alimdl; 
# fi
# echo "Copied final Gmm in $GmmRes/FinalGmm"
# 
# cd $OrPwd








