#!/bin/bash


DnnDir=$1
LMPrepDir=$2
LMRes=$3
GmmRes=$4
SpnRes=$5
InfoRoot=$6
DnnRes=$7
Param="$8"


TrKaldDir=`echo $Param | awk '{print $1}'`	
KaldiRoot=`echo $Param | awk '{print $2}'` # Kaldi Trunk Root

#
OrPwd=`pwd`; 
cd $TrKaldDir
export cuda_cmd=utils/run.pl
enhan=enhanced

nj=1

#
lang=$LMRes/lang #DataDir/lang
langtest=$LMRes/lang_test_tgpr_5k

MDir=$DnnRes/MDir
DataDir=$MDir/data
ExpDir=$MDir/exp


#
mkdir -p $ExpDir/tri3b_tr05_multi_$enhan



##########################################################################

FBankTrData=$DataDir/FBank_tr05_multi_$enhan
FBankDevData=$DataDir/FBank_dt05_multi_$enhan

#Inputs minimum use of results from GPU/Code for correct training with Small: $FBankTrData $ali
# Also same error if I launch directly from terminal (with Matlab path previusly set) or with all Results in GPU (/multispeech/..)
ali=$ExpDir/tri3b_tr05_multi_${enhan}_ali
ali_dev=$ExpDir/tri3b_tr05_multi_${enhan}_ali_dt05 



CpChNa() {
    #Copy and Change Names
   mkdir -p $2; 
   cp $1/CmvnScp.txt $2/cmvn.scp; 
   cp $1/FeatScp.txt $2/feats.scp; 
   cp $1/Spk2Utt.txt $2/spk2utt; 
   cp $1/Utt2Spk.txt $2/utt2spk; 
   cp $1/Text.txt $2/text
}




CpChNa $InfoRoot/FbankTrInfoDir $FBankTrData;
CpChNa $InfoRoot/FbankDevInfoDir $FBankDevData;



FineTunDir=$ExpDir/tri4a_dnn_tr05_multi_$enhan
PreTrDir=$ExpDir/tri4a_dnn_pretrain_tr05_multi_$enhan


# Outputs of pretraining used by training
dbn=$PreTrDir/7.dbn # Output of pretraining
feature_transform=$PreTrDir/final.feature_transform # Output of pretraining



# 
# #
 mkdir -p $ali; mkdir -p $ali_dev; mkdir -p $PreTrDir; mkdir -p $FineTunDir
 
 cp  $GmmRes/final_NoTransf.feature_transform $feature_transform 
 cp  $GmmRes/tree $ali/tree 
 cp  $SpnRes/FinalSpn/final.mdl $ali/final.mdl
 cp  $SpnRes/FinalSpn/GPar/TrAli.1.gz $ali/ali.1.gz
 cp  $SpnRes/FinalSpn/GPar/DevAli.1.gz $ali_dev/ali.1.gz  

 
echo '################################# PRETRAINING #####################################'
$DnnDir/pretrain_dbn.sh --nn-depth 7 --rbm-iter 3 $FBankTrData $PreTrDir $KaldiRoot $feature_transform #1 hour

echo '################################# TRAINING #####################################' 
$DnnDir/train.sh --feature-transform $feature_transform --dbn $dbn --hid-layers 0 --learn-rate 0.008 \
$FBankTrData $FBankDevData $lang $ali $ali_dev $FineTunDir $KaldiRoot || exit 1;


 

# Final result copy
mkdir -p $DnnRes/FinalDnn

cp $FineTunDir/final.nnet $FineTunDir/final.mdl \
$SpnRes/FinalSpn/HCLG.fst \
$FineTunDir/final.feature_transform $FineTunDir/ali_train_pdf.counts $DnnRes/FinalDnn


echo "Copied final Dnn in $DnnRes/FinalDnn"


cd $OrPwd



################################################################################################################
# FUTURE: Delete cp $GmmRes/4Dnn/* $ExpDir/tri3b_tr05_multi_$enhan 
# MfccTrData=$DataDir/Mfcc_tr05_multi_$enhan
# MfccDevData=$DataDir/Mfcc_dt05_multi_$enhan

# Future CpChNa $InfoRoot/MfccTrInfoDir $MfccTrData;
# Future CpChNa $InfoRoot/MfccDevInfoDir $MfccDevData;

# # ############################################ No need if already have the alig and feature transform #########################################################
# # # echo '################################# GMM ALIGN #####################################' 
#   $DnnDir/align_fmllr.sh --nj $nj $MfccTrData $lang $ExpDir/tri3b_tr05_multi_$enhan $ali $KaldiRoot || exit 1;
#   $DnnDir/align_fmllr.sh --nj $nj $MfccDevData $lang $ExpDir/tri3b_tr05_multi_$enhan $ali_dev $KaldiRoot || exit 1;

# # #####################################################################################################

# #########################################################################################
# $LMPrepDir/mkgraph.sh $langtest  $FineTunDir $FineTunDir/graph_tgpr_5k $KaldiRoot $TrKaldDir || exit 1;
# #########################################################################################
# 

# # We copy now fmllr transform (when they are created)     
# Future cp $ali/trans.1 $GmmRes/FinalGmm/Trtrans.1
# Future cp $ali_dev/trans.1 $GmmRes/FinalGmm/Devtrans.1 

