function [PseudoLL]=Unc2LikGramSpn(Y,U,HmmDir,SpnKN,MvnK,UnK,P)
%Uncertainty To Likelihood Gram for Sum Product Network
%
%Y:         featuregram (matrix, row feature channel, column time) (already normalized as MvnK)
%U:         uncertaintygram (matrix) (already normalized as MvnK)
%HmmDir:    Hmm Direrctory. Where the different Spn directories (SpnMatDir) are. 
%           The following variables indicate this SpnMatDir as [HmmDir '/SpnMat_' SpnK '_' MvnK];
%SpnKN:     Spn Kind Number. A number to indicate the Spn directory used from the HmmDir for the inference. 
%           0 (Gmm) 
%           1 (Spn) 
%           2 (SpnMultO)
%           .... (see the switch below).
%MvnK:      Mean Varian Normalization Kind. A string to indicate the Spn used from HmmDir:
%           'GMvn': Global mean normalization, 
%           'HEq': Histogram Equalization.
%UnK:       Uncertainty Kind. A string to indicate the kind of marginalization: 
%           'Spn' (Normal, not uncertainty U used), 
%           'UnSpn' (Uncertainty, U is the uncertainty)
%           'MDSpn' (Missing Data, U is the MD mask)
%P:         Parameter structure (KaldiRoot,...)
%
%PseudoLL:  Pseudo Log Likelihoodgram (matrix, row pdf, column time) 

%
models=ReSaKaldGmm([HmmDir '/final.mdl'],1,P.KaldiRoot);
NPdf=length(models.Pdfs);
%[LPrior,frameCounts]=ReMatPriors([HmmDir '/GPar/TrGPar.mat']); 
%[LPrior2,frameCounts2]=ReKaldPriors([HmmDir '/ali_train_pdf.counts']); 
LPrior=-1; frameCounts=-1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
switch SpnKN     
    case 0
         SpnK='Gmm';  %Gaussian Mixture Model in Spn format      
         SpnMatDir=[HmmDir '/SpnMat_' SpnK '_' MvnK];
    case 1
         SpnK='Spn'; %Sum Product Newtork (no MultiOutput)      
         SpnMatDir=[HmmDir '/SpnMat_' SpnK '_' MvnK];
    case 2
         SpnK='SpnMultO';           
         SpnMatDir=[HmmDir '/SpnMat_' SpnK '_' MvnK];
    case 3
        SpnK='SpnMultO_EM';            
        SpnMatDir=[HmmDir '/SpnMat_' SpnK '_' MvnK];
     case 4
        SpnK='SpnMat_SpnMultO_CE_NoMvn';       
        SpnMatDir=[HmmDir '/' SpnK];
     case 5
        SpnK='SpnMat_SpnMultO_CE_EM_NoMvn';        
        SpnMatDir=[HmmDir '/' SpnK];
end



%CpBSpnEp(SpnMatDir,P); 


%
if strcmp(UnK,'En')
    [X3D,w]=GenMCSamp(Y,U,'En',P); %Generate samples and corresponding weigths
    [PseLL,PseL]=X3D2LogLikSpn(X3D,Y,U,P.MF,SpnMatDir,NPdf,UnK,P);    
    PseudoLL=Av3DLPost(PseLL,PseL,w,'OU2'); %Average the posteriors        
else    
    [PseudoLL]=SpnDir2LogLikUnc(Y,U,P.MF,SpnMatDir,NPdf,UnK,P);
end

%PseudoLL=-1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function CpBSpnEp(SpnMatDir,P)
%Copy the Best Spn (BSpn) from Epochs
%
%  a=dec2base(P.FEOpt3, 4, 2);
% o=[a(1) '_' a(2) '_0_0'];
% MatDir= [HmmDir '/SpnMat_SpnMultO_CE_' MvnK '_' o];

EpDir=[SpnMatDir '/EpDir'];

[MatL]=LsBn12Ext(EpDir,'Spn','*','mat'); 

tr=NaN(20,1);
dev=NaN(20,1);
for i=1:length(MatL)    
    [pn,bn]=fileparts(MatL{i});
    C=strsplit(bn,'_');    
    k=str2double(C{2}(3:end))-1;
    tr(k)=str2double(C{3}(3:end));
    dev(k)=str2double(C{4}(4:end));
end

% plot(tr), hold on, plot(dev,'r'), hold off, , legend('tr','dev'), axis([0 20 0 10]), title([o '_Tr' num2str(min(tr)) '_Dev' num2str(min(dev))]);  pause
% SpnMatDir=[EpDir '/Tmp']; [x,x,x]=mkdir(SpnMatDir);


[v,p]=min(dev);
fn=[SpnMatDir '/SpnGMod.mat'];         
copyfile(MatL{p},fn);
fprintf('Written: %s\n',fn)
pause   


