function S=TrImpSampModDir(doo,P)
%Important Sampling Mod of one Directory
%Part 2/3 (after creation of Fb and StPr for all training).
%

%Juan To Grid Root and Feat Root
% GridRoot='/home/jmorales/Mnt/GRIDData3';
% JuanRoot='/home/jmorales';
% do=strrep(doo, JuanRoot, GridRoot);

do=doo;

%
switch P.TeOpt1
    case 0
        E='y';        
    case 1
        E='x';
end

%Feature and Posterior List of files   
[FL,PL]=FePoFListDir(do, ['.Fb' E],['.StPr' E]);

%Read config for context features
fek='Fbank'; tek='Dnn'; 
HmmDir=[P.HmmDir '/Final' fek tek];
FTFilePath=[HmmDir '/final.feature_transform'];
config=readkaldiFTFile(FTFilePath);

%Compute Model
[M,V,PS,FW,VW]=FePoL2FeStMod(FL,PL,config);

%Save
FeStMod=[do '/FeStMod' E '.mat'];
save(FeStMod,'M','V','PS','FW','VW');
fprintf('Written Import Sampling model in %s\n',FeStMod);

% %Load
% S=load(FeStMod);
% subplot(211), jimagesc(S.M)
% subplot(212), jimagesc(S.V)

S='-1';


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [CList,CList2]=FePoFListDir(FeatDir,Ext1,Ext2)
%Cell File List from Several Folders (TrDir)

fprintf('Reading training files ....\n');
CList=LsBn12Ext(FeatDir,'','*',Ext1);

l=length(CList);
CList2=cell(l,1);
for i=1:l
    CList2{i}=strrep(CList{i}, Ext1, Ext2);
end
